/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.format.datetime.joda;

import java.util.Locale;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.core.NamedThreadLocal;
import org.springframework.format.datetime.joda.JodaTimeContext;

public final class JodaTimeContextHolder {
    private static final ThreadLocal<JodaTimeContext> jodaTimeContextHolder = new NamedThreadLocal<JodaTimeContext>("JodaTime Context");

    public static void resetJodaTimeContext() {
        jodaTimeContextHolder.remove();
    }

    public static void setJodaTimeContext(JodaTimeContext jodaTimeContext) {
        if (jodaTimeContext == null) {
            JodaTimeContextHolder.resetJodaTimeContext();
        } else {
            jodaTimeContextHolder.set(jodaTimeContext);
        }
    }

    public static JodaTimeContext getJodaTimeContext() {
        return jodaTimeContextHolder.get();
    }

    public static DateTimeFormatter getFormatter(DateTimeFormatter formatter2, Locale locale) {
        DateTimeFormatter formatterToUse = locale != null ? formatter2.withLocale(locale) : formatter2;
        JodaTimeContext context = JodaTimeContextHolder.getJodaTimeContext();
        return context != null ? context.getFormatter(formatterToUse) : formatterToUse;
    }
}

