/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.format.datetime.joda;

import java.util.TimeZone;
import org.joda.time.Chronology;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.i18n.TimeZoneAwareLocaleContext;

public class JodaTimeContext {
    private Chronology chronology;
    private DateTimeZone timeZone;

    public void setChronology(Chronology chronology) {
        this.chronology = chronology;
    }

    public Chronology getChronology() {
        return this.chronology;
    }

    public void setTimeZone(DateTimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public DateTimeZone getTimeZone() {
        return this.timeZone;
    }

    public DateTimeFormatter getFormatter(DateTimeFormatter formatter2) {
        if (this.chronology != null) {
            formatter2 = formatter2.withChronology(this.chronology);
        }
        if (this.timeZone != null) {
            formatter2 = formatter2.withZone(this.timeZone);
        } else {
            TimeZone timeZone;
            LocaleContext localeContext = LocaleContextHolder.getLocaleContext();
            if (localeContext instanceof TimeZoneAwareLocaleContext && (timeZone = ((TimeZoneAwareLocaleContext)localeContext).getTimeZone()) != null) {
                formatter2 = formatter2.withZone(DateTimeZone.forTimeZone((TimeZone)timeZone));
            }
        }
        return formatter2;
    }
}

