/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.support;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.MethodExecutor;
import org.springframework.expression.MethodFilter;
import org.springframework.expression.MethodResolver;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.support.ReflectionHelper;
import org.springframework.expression.spel.support.ReflectiveMethodExecutor;

public class ReflectiveMethodResolver
implements MethodResolver {
    private final boolean useDistance;
    private Map<Class<?>, MethodFilter> filters;

    public ReflectiveMethodResolver() {
        this.useDistance = true;
    }

    public ReflectiveMethodResolver(boolean useDistance) {
        this.useDistance = useDistance;
    }

    public void registerMethodFilter(Class<?> type2, MethodFilter filter2) {
        if (this.filters == null) {
            this.filters = new HashMap();
        }
        if (filter2 != null) {
            this.filters.put(type2, filter2);
        } else {
            this.filters.remove(type2);
        }
    }

    @Override
    public MethodExecutor resolve(EvaluationContext context, Object targetObject, String name2, List<TypeDescriptor> argumentTypes) throws AccessException {
        try {
            MethodFilter filter2;
            TypeConverter typeConverter = context.getTypeConverter();
            Class<?> type2 = targetObject instanceof Class ? (Class<?>)targetObject : targetObject.getClass();
            ArrayList<Method> methods2 = new ArrayList<Method>(this.getMethods(type2, targetObject));
            MethodFilter methodFilter = filter2 = this.filters != null ? this.filters.get(type2) : null;
            if (filter2 != null) {
                ArrayList<Method> filtered = filter2.filter(methods2);
                ArrayList<Method> arrayList = methods2 = filtered instanceof ArrayList ? filtered : new ArrayList<Method>(filtered);
            }
            if (methods2.size() > 1) {
                Collections.sort(methods2, new Comparator<Method>(){

                    @Override
                    public int compare(Method m1, Method m2) {
                        int m2pl;
                        int m1pl = m1.getParameterTypes().length;
                        if (m1pl == (m2pl = m2.getParameterTypes().length)) {
                            if (!m1.isVarArgs() && m2.isVarArgs()) {
                                return -1;
                            }
                            if (m1.isVarArgs() && !m2.isVarArgs()) {
                                return 1;
                            }
                            return 0;
                        }
                        return m1pl < m2pl ? -1 : (m1pl > m2pl ? 1 : 0);
                    }
                });
            }
            for (int i = 0; i < methods2.size(); ++i) {
                methods2.set(i, BridgeMethodResolver.findBridgedMethod((Method)methods2.get(i)));
            }
            LinkedHashSet methodsToIterate = new LinkedHashSet(methods2);
            Method closeMatch = null;
            int closeMatchDistance = Integer.MAX_VALUE;
            Method matchRequiringConversion = null;
            boolean multipleOptions = false;
            for (Method method : methodsToIterate) {
                if (!method.getName().equals(name2)) continue;
                Class<?>[] paramTypes = method.getParameterTypes();
                ArrayList<TypeDescriptor> paramDescriptors = new ArrayList<TypeDescriptor>(paramTypes.length);
                for (int i = 0; i < paramTypes.length; ++i) {
                    paramDescriptors.add(new TypeDescriptor(new MethodParameter(method, i)));
                }
                ReflectionHelper.ArgumentsMatchInfo matchInfo = null;
                if (method.isVarArgs() && argumentTypes.size() >= paramTypes.length - 1) {
                    matchInfo = ReflectionHelper.compareArgumentsVarargs(paramDescriptors, argumentTypes, typeConverter);
                } else if (paramTypes.length == argumentTypes.size()) {
                    matchInfo = ReflectionHelper.compareArguments(paramDescriptors, argumentTypes, typeConverter);
                }
                if (matchInfo == null) continue;
                if (matchInfo.isExactMatch()) {
                    return new ReflectiveMethodExecutor(method);
                }
                if (matchInfo.isCloseMatch()) {
                    if (this.useDistance) {
                        int matchDistance = ReflectionHelper.getTypeDifferenceWeight(paramDescriptors, argumentTypes);
                        if (closeMatch != null && matchDistance >= closeMatchDistance) continue;
                        closeMatch = method;
                        closeMatchDistance = matchDistance;
                        continue;
                    }
                    if (closeMatch != null) continue;
                    closeMatch = method;
                    continue;
                }
                if (!matchInfo.isMatchRequiringConversion()) continue;
                if (matchRequiringConversion != null) {
                    multipleOptions = true;
                }
                matchRequiringConversion = method;
            }
            if (closeMatch != null) {
                return new ReflectiveMethodExecutor(closeMatch);
            }
            if (matchRequiringConversion != null) {
                if (multipleOptions) {
                    throw new SpelEvaluationException(SpelMessage.MULTIPLE_POSSIBLE_METHODS, name2);
                }
                return new ReflectiveMethodExecutor(matchRequiringConversion);
            }
            return null;
        }
        catch (EvaluationException ex) {
            throw new AccessException("Failed to resolve method", ex);
        }
    }

    private Collection<Method> getMethods(Class<?> type2, Object targetObject) {
        if (targetObject instanceof Class) {
            Method[] methods2;
            LinkedHashSet<Method> result = new LinkedHashSet<Method>();
            result.addAll(Arrays.asList(this.getMethods(targetObject.getClass())));
            for (Method method : methods2 = this.getMethods(type2)) {
                if (!Modifier.isStatic(method.getModifiers())) continue;
                result.add(method);
            }
            return result;
        }
        return Arrays.asList(this.getMethods(type2));
    }

    protected Method[] getMethods(Class<?> type2) {
        return type2.getMethods();
    }
}

