/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.Operation;
import org.springframework.expression.OperatorOverloader;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypeComparator;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.util.Assert;

public class ExpressionState {
    private final EvaluationContext relatedContext;
    private final TypedValue rootObject;
    private Stack<TypedValue> scopeRootObjects;
    private final SpelParserConfiguration configuration;
    private Stack<VariableScope> variableScopes;
    private Stack<TypedValue> contextObjects;

    public ExpressionState(EvaluationContext context) {
        this(context, context.getRootObject(), new SpelParserConfiguration(false, false));
    }

    public ExpressionState(EvaluationContext context, SpelParserConfiguration configuration) {
        this(context, context.getRootObject(), configuration);
    }

    public ExpressionState(EvaluationContext context, TypedValue rootObject) {
        this(context, rootObject, new SpelParserConfiguration(false, false));
    }

    public ExpressionState(EvaluationContext context, TypedValue rootObject, SpelParserConfiguration configuration) {
        Assert.notNull(context, "EvaluationContext must not be null");
        Assert.notNull(configuration, "SpelParserConfiguration must not be null");
        this.relatedContext = context;
        this.rootObject = rootObject;
        this.configuration = configuration;
    }

    private void ensureVariableScopesInitialized() {
        if (this.variableScopes == null) {
            this.variableScopes = new Stack();
            this.variableScopes.add(new VariableScope());
        }
        if (this.scopeRootObjects == null) {
            this.scopeRootObjects = new Stack();
        }
    }

    public TypedValue getActiveContextObject() {
        if (this.contextObjects == null || this.contextObjects.isEmpty()) {
            return this.rootObject;
        }
        return this.contextObjects.peek();
    }

    public void pushActiveContextObject(TypedValue obj) {
        if (this.contextObjects == null) {
            this.contextObjects = new Stack();
        }
        this.contextObjects.push(obj);
    }

    public void popActiveContextObject() {
        if (this.contextObjects == null) {
            this.contextObjects = new Stack();
        }
        this.contextObjects.pop();
    }

    public TypedValue getRootContextObject() {
        return this.rootObject;
    }

    public TypedValue getScopeRootContextObject() {
        if (this.scopeRootObjects == null || this.scopeRootObjects.isEmpty()) {
            return this.rootObject;
        }
        return this.scopeRootObjects.peek();
    }

    public void setVariable(String name2, Object value) {
        this.relatedContext.setVariable(name2, value);
    }

    public TypedValue lookupVariable(String name2) {
        Object value = this.relatedContext.lookupVariable(name2);
        if (value == null) {
            return TypedValue.NULL;
        }
        return new TypedValue(value);
    }

    public TypeComparator getTypeComparator() {
        return this.relatedContext.getTypeComparator();
    }

    public Class<?> findType(String type2) throws EvaluationException {
        return this.relatedContext.getTypeLocator().findType(type2);
    }

    public Object convertValue(Object value, TypeDescriptor targetTypeDescriptor) throws EvaluationException {
        return this.relatedContext.getTypeConverter().convertValue(value, TypeDescriptor.forObject(value), targetTypeDescriptor);
    }

    public TypeConverter getTypeConverter() {
        return this.relatedContext.getTypeConverter();
    }

    public Object convertValue(TypedValue value, TypeDescriptor targetTypeDescriptor) throws EvaluationException {
        Object val2 = value.getValue();
        return this.relatedContext.getTypeConverter().convertValue(val2, TypeDescriptor.forObject(val2), targetTypeDescriptor);
    }

    public void enterScope(Map<String, Object> argMap) {
        this.ensureVariableScopesInitialized();
        this.variableScopes.push(new VariableScope(argMap));
        this.scopeRootObjects.push(this.getActiveContextObject());
    }

    public void enterScope() {
        this.ensureVariableScopesInitialized();
        this.variableScopes.push(new VariableScope(Collections.<String, Object>emptyMap()));
        this.scopeRootObjects.push(this.getActiveContextObject());
    }

    public void enterScope(String name2, Object value) {
        this.ensureVariableScopesInitialized();
        this.variableScopes.push(new VariableScope(name2, value));
        this.scopeRootObjects.push(this.getActiveContextObject());
    }

    public void exitScope() {
        this.ensureVariableScopesInitialized();
        this.variableScopes.pop();
        this.scopeRootObjects.pop();
    }

    public void setLocalVariable(String name2, Object value) {
        this.ensureVariableScopesInitialized();
        this.variableScopes.peek().setVariable(name2, value);
    }

    public Object lookupLocalVariable(String name2) {
        int scopeNumber;
        this.ensureVariableScopesInitialized();
        for (int i = scopeNumber = this.variableScopes.size() - 1; i >= 0; --i) {
            if (!((VariableScope)this.variableScopes.get(i)).definesVariable(name2)) continue;
            return ((VariableScope)this.variableScopes.get(i)).lookupVariable(name2);
        }
        return null;
    }

    public TypedValue operate(Operation op, Object left2, Object right2) throws EvaluationException {
        OperatorOverloader overloader = this.relatedContext.getOperatorOverloader();
        if (overloader.overridesOperation(op, left2, right2)) {
            Object returnValue = overloader.operate(op, left2, right2);
            return new TypedValue(returnValue);
        }
        String leftType = left2 == null ? "null" : left2.getClass().getName();
        String rightType = right2 == null ? "null" : right2.getClass().getName();
        throw new SpelEvaluationException(SpelMessage.OPERATOR_NOT_SUPPORTED_BETWEEN_TYPES, new Object[]{op, leftType, rightType});
    }

    public List<PropertyAccessor> getPropertyAccessors() {
        return this.relatedContext.getPropertyAccessors();
    }

    public EvaluationContext getEvaluationContext() {
        return this.relatedContext;
    }

    public SpelParserConfiguration getConfiguration() {
        return this.configuration;
    }

    private static class VariableScope {
        private final Map<String, Object> vars = new HashMap<String, Object>();

        public VariableScope() {
        }

        public VariableScope(Map<String, Object> arguments) {
            if (arguments != null) {
                this.vars.putAll(arguments);
            }
        }

        public VariableScope(String name2, Object value) {
            this.vars.put(name2, value);
        }

        public Object lookupVariable(String name2) {
            return this.vars.get(name2);
        }

        public void setVariable(String name2, Object value) {
            this.vars.put(name2, value);
        }

        public boolean definesVariable(String name2) {
            return this.vars.containsKey(name2);
        }
    }
}

