/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.util.ClassUtils;

public abstract class OrderUtils {
    private static Class<? extends Annotation> priorityAnnotationType = null;

    public static Integer getOrder(Class<?> type2) {
        return OrderUtils.getOrder(type2, null);
    }

    public static Integer getOrder(Class<?> type2, Integer defaultOrder) {
        Order order = AnnotationUtils.findAnnotation(type2, Order.class);
        if (order != null) {
            return order.value();
        }
        Integer priorityOrder = OrderUtils.getPriority(type2);
        if (priorityOrder != null) {
            return priorityOrder;
        }
        return defaultOrder;
    }

    public static Integer getPriority(Class<?> type2) {
        Annotation priority;
        if (priorityAnnotationType != null && (priority = AnnotationUtils.findAnnotation(type2, priorityAnnotationType)) != null) {
            return (Integer)AnnotationUtils.getValue(priority);
        }
        return null;
    }

    static {
        try {
            priorityAnnotationType = ClassUtils.forName("javax.annotation.Priority", OrderUtils.class.getClassLoader());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

