/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SpringProperties {
    private static final String PROPERTIES_RESOURCE_LOCATION = "spring.properties";
    private static final Log logger;
    private static final Properties localProperties;

    public static void setProperty(String key2, String value) {
        if (value != null) {
            localProperties.setProperty(key2, value);
        } else {
            localProperties.remove(key2);
        }
    }

    public static String getProperty(String key2) {
        String value;
        block3: {
            value = localProperties.getProperty(key2);
            if (value == null) {
                try {
                    value = System.getProperty(key2);
                }
                catch (Throwable ex) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug("Could not retrieve system property '" + key2 + "': " + ex);
                }
            }
        }
        return value;
    }

    public static void setFlag(String key2) {
        localProperties.put(key2, Boolean.TRUE.toString());
    }

    public static boolean getFlag(String key2) {
        return Boolean.parseBoolean(SpringProperties.getProperty(key2));
    }

    static {
        block5: {
            logger = LogFactory.getLog(SpringProperties.class);
            localProperties = new Properties();
            try {
                URL url;
                ClassLoader cl = SpringProperties.class.getClassLoader();
                URL uRL = url = cl != null ? cl.getResource(PROPERTIES_RESOURCE_LOCATION) : ClassLoader.getSystemResource(PROPERTIES_RESOURCE_LOCATION);
                if (url == null) break block5;
                logger.info("Found 'spring.properties' file in local classpath");
                InputStream is2 = url.openStream();
                try {
                    localProperties.load(is2);
                }
                finally {
                    is2.close();
                }
            }
            catch (IOException ex) {
                if (!logger.isInfoEnabled()) break block5;
                logger.info("Could not load 'spring.properties' file from local classpath: " + ex);
            }
        }
    }
}

