/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.io.IOException;
import java.io.InputStream;
import org.springframework.core.DecoratingClassLoader;
import org.springframework.lang.UsesJava7;
import org.springframework.util.FileCopyUtils;

@UsesJava7
public class OverridingClassLoader
extends DecoratingClassLoader {
    public static final String[] DEFAULT_EXCLUDED_PACKAGES = new String[]{"java.", "javax.", "sun.", "oracle."};
    private static final String CLASS_FILE_SUFFIX = ".class";

    public OverridingClassLoader(ClassLoader parent) {
        super(parent);
        for (String packageName : DEFAULT_EXCLUDED_PACKAGES) {
            this.excludePackage(packageName);
        }
    }

    @Override
    protected Class<?> loadClass(String name2, boolean resolve2) throws ClassNotFoundException {
        Class<?> result = null;
        if (this.isEligibleForOverriding(name2)) {
            result = this.loadClassForOverriding(name2);
        }
        if (result != null) {
            if (resolve2) {
                this.resolveClass(result);
            }
            return result;
        }
        return super.loadClass(name2, resolve2);
    }

    protected boolean isEligibleForOverriding(String className) {
        return !this.isExcluded(className);
    }

    protected Class<?> loadClassForOverriding(String name2) throws ClassNotFoundException {
        byte[] bytes2;
        Class<?> result = this.findLoadedClass(name2);
        if (result == null && (bytes2 = this.loadBytesForClass(name2)) != null) {
            result = this.defineClass(name2, bytes2, 0, bytes2.length);
        }
        return result;
    }

    protected byte[] loadBytesForClass(String name2) throws ClassNotFoundException {
        InputStream is2 = this.openStreamForClass(name2);
        if (is2 == null) {
            return null;
        }
        try {
            byte[] bytes2 = FileCopyUtils.copyToByteArray(is2);
            return this.transformIfNecessary(name2, bytes2);
        }
        catch (IOException ex) {
            throw new ClassNotFoundException("Cannot load resource for class [" + name2 + "]", ex);
        }
    }

    protected InputStream openStreamForClass(String name2) {
        String internalName = name2.replace('.', '/') + CLASS_FILE_SUFFIX;
        return this.getParent().getResourceAsStream(internalName);
    }

    protected byte[] transformIfNecessary(String name2, byte[] bytes2) {
        return bytes2;
    }

    static {
        if (parallelCapableClassLoaderAvailable) {
            ClassLoader.registerAsParallelCapable();
        }
    }
}

