/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.context.support.AbstractMessageSource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class ResourceBundleMessageSource
extends AbstractMessageSource
implements BeanClassLoaderAware {
    private String[] basenames = new String[0];
    private String defaultEncoding = "ISO-8859-1";
    private boolean fallbackToSystemLocale = true;
    private long cacheMillis = -1L;
    private ClassLoader bundleClassLoader;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private final Map<String, Map<Locale, ResourceBundle>> cachedResourceBundles = new HashMap<String, Map<Locale, ResourceBundle>>();
    private final Map<ResourceBundle, Map<String, Map<Locale, MessageFormat>>> cachedBundleMessageFormats = new HashMap<ResourceBundle, Map<String, Map<Locale, MessageFormat>>>();

    public void setBasename(String basename) {
        this.setBasenames(basename);
    }

    public void setBasenames(String ... basenames) {
        if (basenames != null) {
            this.basenames = new String[basenames.length];
            for (int i = 0; i < basenames.length; ++i) {
                String basename = basenames[i];
                Assert.hasText(basename, "Basename must not be empty");
                this.basenames[i] = basename.trim();
            }
        } else {
            this.basenames = new String[0];
        }
    }

    public void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    public void setFallbackToSystemLocale(boolean fallbackToSystemLocale) {
        this.fallbackToSystemLocale = fallbackToSystemLocale;
    }

    public void setCacheSeconds(int cacheSeconds) {
        this.cacheMillis = cacheSeconds * 1000;
    }

    public void setBundleClassLoader(ClassLoader classLoader) {
        this.bundleClassLoader = classLoader;
    }

    protected ClassLoader getBundleClassLoader() {
        return this.bundleClassLoader != null ? this.bundleClassLoader : this.beanClassLoader;
    }

    @Override
    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader != null ? classLoader : ClassUtils.getDefaultClassLoader();
    }

    @Override
    protected String resolveCodeWithoutArguments(String code, Locale locale) {
        String result = null;
        for (int i = 0; result == null && i < this.basenames.length; ++i) {
            ResourceBundle bundle2 = this.getResourceBundle(this.basenames[i], locale);
            if (bundle2 == null) continue;
            result = this.getStringOrNull(bundle2, code);
        }
        return result;
    }

    @Override
    protected MessageFormat resolveCode(String code, Locale locale) {
        MessageFormat messageFormat = null;
        for (int i = 0; messageFormat == null && i < this.basenames.length; ++i) {
            ResourceBundle bundle2 = this.getResourceBundle(this.basenames[i], locale);
            if (bundle2 == null) continue;
            messageFormat = this.getMessageFormat(bundle2, code, locale);
        }
        return messageFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResourceBundle getResourceBundle(String basename, Locale locale) {
        if (this.cacheMillis >= 0L) {
            return this.doGetBundle(basename, locale);
        }
        Map<String, Map<Locale, ResourceBundle>> map2 = this.cachedResourceBundles;
        synchronized (map2) {
            ResourceBundle bundle2;
            Map<Locale, ResourceBundle> localeMap = this.cachedResourceBundles.get(basename);
            if (localeMap != null && (bundle2 = localeMap.get(locale)) != null) {
                return bundle2;
            }
            try {
                bundle2 = this.doGetBundle(basename, locale);
                if (localeMap == null) {
                    localeMap = new HashMap<Locale, ResourceBundle>();
                    this.cachedResourceBundles.put(basename, localeMap);
                }
                localeMap.put(locale, bundle2);
                return bundle2;
            }
            catch (MissingResourceException ex) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("ResourceBundle [" + basename + "] not found for MessageSource: " + ex.getMessage());
                }
                return null;
            }
        }
    }

    protected ResourceBundle doGetBundle(String basename, Locale locale) throws MissingResourceException {
        return ResourceBundle.getBundle(basename, locale, this.getBundleClassLoader(), new MessageSourceControl());
    }

    protected ResourceBundle loadBundle(Reader reader2) throws IOException {
        return new PropertyResourceBundle(reader2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MessageFormat getMessageFormat(ResourceBundle bundle2, String code, Locale locale) throws MissingResourceException {
        Map<ResourceBundle, Map<String, Map<Locale, MessageFormat>>> map2 = this.cachedBundleMessageFormats;
        synchronized (map2) {
            MessageFormat result;
            Map<String, Map<Locale, MessageFormat>> codeMap = this.cachedBundleMessageFormats.get(bundle2);
            Map<Locale, MessageFormat> localeMap = null;
            if (codeMap != null && (localeMap = codeMap.get(code)) != null && (result = localeMap.get(locale)) != null) {
                return result;
            }
            String msg = this.getStringOrNull(bundle2, code);
            if (msg != null) {
                if (codeMap == null) {
                    codeMap = new HashMap<String, Map<Locale, MessageFormat>>();
                    this.cachedBundleMessageFormats.put(bundle2, codeMap);
                }
                if (localeMap == null) {
                    localeMap = new HashMap<Locale, MessageFormat>();
                    codeMap.put(code, localeMap);
                }
                MessageFormat result2 = this.createMessageFormat(msg, locale);
                localeMap.put(locale, result2);
                return result2;
            }
            return null;
        }
    }

    protected String getStringOrNull(ResourceBundle bundle2, String key2) {
        if (bundle2.containsKey(key2)) {
            try {
                return bundle2.getString(key2);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return null;
    }

    public String toString() {
        return this.getClass().getName() + ": basenames=[" + StringUtils.arrayToCommaDelimitedString(this.basenames) + "]";
    }

    private class MessageSourceControl
    extends ResourceBundle.Control {
        private MessageSourceControl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format2, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            if (format2.equals("java.properties")) {
                InputStream stream;
                String bundleName = this.toBundleName(baseName, locale);
                final String resourceName = this.toResourceName(bundleName, "properties");
                final ClassLoader classLoader = loader;
                final boolean reloadFlag = reload;
                try {
                    stream = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                        @Override
                        public InputStream run() throws IOException {
                            InputStream is2 = null;
                            if (reloadFlag) {
                                URLConnection connection;
                                URL url = classLoader.getResource(resourceName);
                                if (url != null && (connection = url.openConnection()) != null) {
                                    connection.setUseCaches(false);
                                    is2 = connection.getInputStream();
                                }
                            } else {
                                is2 = classLoader.getResourceAsStream(resourceName);
                            }
                            return is2;
                        }
                    });
                }
                catch (PrivilegedActionException ex) {
                    throw (IOException)ex.getException();
                }
                if (stream != null) {
                    try {
                        ResourceBundle resourceBundle = ResourceBundleMessageSource.this.loadBundle(new InputStreamReader(stream, ResourceBundleMessageSource.this.defaultEncoding));
                        return resourceBundle;
                    }
                    finally {
                        stream.close();
                    }
                }
                return null;
            }
            return super.newBundle(baseName, locale, format2, loader, reload);
        }

        @Override
        public Locale getFallbackLocale(String baseName, Locale locale) {
            return ResourceBundleMessageSource.this.fallbackToSystemLocale ? super.getFallbackLocale(baseName, locale) : null;
        }

        @Override
        public long getTimeToLive(String baseName, Locale locale) {
            return ResourceBundleMessageSource.this.cacheMillis >= 0L ? ResourceBundleMessageSource.this.cacheMillis : super.getTimeToLive(baseName, locale);
        }

        @Override
        public boolean needsReload(String baseName, Locale locale, String format2, ClassLoader loader, ResourceBundle bundle2, long loadTime) {
            if (super.needsReload(baseName, locale, format2, loader, bundle2, loadTime)) {
                ResourceBundleMessageSource.this.cachedBundleMessageFormats.remove(bundle2);
                return true;
            }
            return false;
        }
    }
}

