/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.event;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.SpringProxy;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ApplicationListenerMethodAdapter;
import org.springframework.context.event.EventExpressionEvaluator;
import org.springframework.context.event.EventListener;
import org.springframework.context.event.EventListenerFactory;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class EventListenerMethodProcessor
implements SmartInitializingSingleton,
ApplicationContextAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ConfigurableApplicationContext applicationContext;
    private final EventExpressionEvaluator evaluator = new EventExpressionEvaluator();
    private final Set<Class<?>> nonAnnotatedClasses = Collections.newSetFromMap(new ConcurrentHashMap(64));

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Assert.isTrue(applicationContext instanceof ConfigurableApplicationContext, "ApplicationContext does not implement ConfigurableApplicationContext");
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
    }

    protected List<EventListenerFactory> getEventListenerFactories() {
        Map<String, EventListenerFactory> beans = this.applicationContext.getBeansOfType(EventListenerFactory.class);
        ArrayList<EventListenerFactory> allFactories = new ArrayList<EventListenerFactory>(beans.values());
        AnnotationAwareOrderComparator.sort(allFactories);
        return allFactories;
    }

    @Override
    public void afterSingletonsInstantiated() {
        String[] allBeanNames;
        List<EventListenerFactory> factories = this.getEventListenerFactories();
        for (String beanName : allBeanNames = this.applicationContext.getBeanNamesForType(Object.class)) {
            if (ScopedProxyUtils.isScopedTarget(beanName)) continue;
            Class<?> type2 = this.applicationContext.getType(beanName);
            try {
                this.processBean(factories, beanName, type2);
            }
            catch (RuntimeException e2) {
                throw new BeanInitializationException("Failed to process @EventListener annotation on bean with name '" + beanName + "'", e2);
            }
        }
    }

    protected void processBean(List<EventListenerFactory> factories, String beanName, Class<?> type2) {
        Class<?> targetType = this.getTargetClass(beanName, type2);
        if (!this.nonAnnotatedClasses.contains(targetType)) {
            Method[] methods2;
            LinkedHashSet<Method> annotatedMethods = new LinkedHashSet<Method>(1);
            block0: for (Method method : methods2 = ReflectionUtils.getUniqueDeclaredMethods(targetType)) {
                EventListener eventListener = AnnotationUtils.findAnnotation(method, EventListener.class);
                if (eventListener == null) continue;
                for (EventListenerFactory factory : factories) {
                    ApplicationListener<?> applicationListener;
                    if (!factory.supportsMethod(method)) continue;
                    if (!type2.equals(targetType)) {
                        method = this.getProxyMethod(type2, method);
                    }
                    if ((applicationListener = factory.createApplicationListener(beanName, type2, method)) instanceof ApplicationListenerMethodAdapter) {
                        ((ApplicationListenerMethodAdapter)applicationListener).init(this.applicationContext, this.evaluator);
                    }
                    this.applicationContext.addApplicationListener(applicationListener);
                    annotatedMethods.add(method);
                    continue block0;
                }
            }
            if (annotatedMethods.isEmpty()) {
                this.nonAnnotatedClasses.add(type2);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("No @EventListener annotations found on bean class: " + type2);
                }
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug(annotatedMethods.size() + " @EventListener methods processed on bean '" + beanName + "': " + annotatedMethods);
            }
        }
    }

    private Class<?> getTargetClass(String beanName, Class<?> type2) {
        if (SpringProxy.class.isAssignableFrom(type2)) {
            Object bean2 = this.applicationContext.getBean(beanName);
            return AopUtils.getTargetClass(bean2);
        }
        return type2;
    }

    private Method getProxyMethod(Class<?> proxyType, Method method) {
        try {
            return proxyType.getMethod(method.getName(), method.getParameterTypes());
        }
        catch (SecurityException ex) {
            ReflectionUtils.handleReflectionException(ex);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException(String.format("@EventListener method '%s' found on bean target class '%s', but not found in any interface(s) for bean JDK proxy. Either pull the method up to an interface or switch to subclass (CGLIB) proxies by setting proxy-target-class/proxyTargetClass attribute to 'true'", method.getName(), method.getDeclaringClass().getSimpleName()));
        }
        return null;
    }
}

