/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.transform.impl;

import org.springframework.asm.Label;
import org.springframework.asm.Type;
import org.springframework.cglib.core.CodeEmitter;
import org.springframework.cglib.core.Constants;
import org.springframework.cglib.core.Local;
import org.springframework.cglib.core.Signature;
import org.springframework.cglib.core.TypeUtils;
import org.springframework.cglib.transform.ClassEmitterTransformer;
import org.springframework.cglib.transform.impl.InterceptFieldFilter;

public class InterceptFieldTransformer
extends ClassEmitterTransformer {
    private static final String CALLBACK_FIELD = "$CGLIB_READ_WRITE_CALLBACK";
    private static final Type CALLBACK = TypeUtils.parseType("org.springframework.cglib.transform.impl.InterceptFieldCallback");
    private static final Type ENABLED = TypeUtils.parseType("org.springframework.cglib.transform.impl.InterceptFieldEnabled");
    private static final Signature ENABLED_SET = new Signature("setInterceptFieldCallback", Type.VOID_TYPE, new Type[]{CALLBACK});
    private static final Signature ENABLED_GET = new Signature("getInterceptFieldCallback", CALLBACK, new Type[0]);
    private InterceptFieldFilter filter;

    public InterceptFieldTransformer(InterceptFieldFilter filter2) {
        this.filter = filter2;
    }

    public void begin_class(int version, int access, String className, Type superType, Type[] interfaces, String sourceFile) {
        if (!TypeUtils.isInterface(access)) {
            super.begin_class(version, access, className, superType, TypeUtils.add(interfaces, ENABLED), sourceFile);
            super.declare_field(130, CALLBACK_FIELD, CALLBACK, null);
            CodeEmitter e2 = super.begin_method(1, ENABLED_GET, null);
            e2.load_this();
            e2.getfield(CALLBACK_FIELD);
            e2.return_value();
            e2.end_method();
            e2 = super.begin_method(1, ENABLED_SET, null);
            e2.load_this();
            e2.load_arg(0);
            e2.putfield(CALLBACK_FIELD);
            e2.return_value();
            e2.end_method();
        } else {
            super.begin_class(version, access, className, superType, interfaces, sourceFile);
        }
    }

    public void declare_field(int access, String name2, Type type2, Object value) {
        super.declare_field(access, name2, type2, value);
        if (!TypeUtils.isStatic(access)) {
            if (this.filter.acceptRead(this.getClassType(), name2)) {
                this.addReadMethod(name2, type2);
            }
            if (this.filter.acceptWrite(this.getClassType(), name2)) {
                this.addWriteMethod(name2, type2);
            }
        }
    }

    private void addReadMethod(String name2, Type type2) {
        CodeEmitter e2 = super.begin_method(1, InterceptFieldTransformer.readMethodSig(name2, type2.getDescriptor()), null);
        e2.load_this();
        e2.getfield(name2);
        e2.load_this();
        e2.invoke_interface(ENABLED, ENABLED_GET);
        Label intercept = e2.make_label();
        e2.ifnonnull(intercept);
        e2.return_value();
        e2.mark(intercept);
        Local result = e2.make_local(type2);
        e2.store_local(result);
        e2.load_this();
        e2.invoke_interface(ENABLED, ENABLED_GET);
        e2.load_this();
        e2.push(name2);
        e2.load_local(result);
        e2.invoke_interface(CALLBACK, InterceptFieldTransformer.readCallbackSig(type2));
        if (!TypeUtils.isPrimitive(type2)) {
            e2.checkcast(type2);
        }
        e2.return_value();
        e2.end_method();
    }

    private void addWriteMethod(String name2, Type type2) {
        CodeEmitter e2 = super.begin_method(1, InterceptFieldTransformer.writeMethodSig(name2, type2.getDescriptor()), null);
        e2.load_this();
        e2.dup();
        e2.invoke_interface(ENABLED, ENABLED_GET);
        Label skip = e2.make_label();
        e2.ifnull(skip);
        e2.load_this();
        e2.invoke_interface(ENABLED, ENABLED_GET);
        e2.load_this();
        e2.push(name2);
        e2.load_this();
        e2.getfield(name2);
        e2.load_arg(0);
        e2.invoke_interface(CALLBACK, InterceptFieldTransformer.writeCallbackSig(type2));
        if (!TypeUtils.isPrimitive(type2)) {
            e2.checkcast(type2);
        }
        Label go = e2.make_label();
        e2.goTo(go);
        e2.mark(skip);
        e2.load_arg(0);
        e2.mark(go);
        e2.putfield(name2);
        e2.return_value();
        e2.end_method();
    }

    public CodeEmitter begin_method(int access, Signature sig, Type[] exceptions) {
        return new CodeEmitter(super.begin_method(access, sig, exceptions)){

            public void visitFieldInsn(int opcode, String owner, String name2, String desc) {
                Type towner = TypeUtils.fromInternalName(owner);
                switch (opcode) {
                    case 180: {
                        if (!InterceptFieldTransformer.this.filter.acceptRead(towner, name2)) break;
                        this.helper(towner, InterceptFieldTransformer.readMethodSig(name2, desc));
                        return;
                    }
                    case 181: {
                        if (!InterceptFieldTransformer.this.filter.acceptWrite(towner, name2)) break;
                        this.helper(towner, InterceptFieldTransformer.writeMethodSig(name2, desc));
                        return;
                    }
                }
                super.visitFieldInsn(opcode, owner, name2, desc);
            }

            private void helper(Type owner, Signature sig) {
                this.invoke_virtual(owner, sig);
            }
        };
    }

    private static Signature readMethodSig(String name2, String desc) {
        return new Signature("$cglib_read_" + name2, "()" + desc);
    }

    private static Signature writeMethodSig(String name2, String desc) {
        return new Signature("$cglib_write_" + name2, "(" + desc + ")V");
    }

    private static Signature readCallbackSig(Type type2) {
        Type remap = InterceptFieldTransformer.remap(type2);
        return new Signature("read" + InterceptFieldTransformer.callbackName(remap), remap, new Type[]{Constants.TYPE_OBJECT, Constants.TYPE_STRING, remap});
    }

    private static Signature writeCallbackSig(Type type2) {
        Type remap = InterceptFieldTransformer.remap(type2);
        return new Signature("write" + InterceptFieldTransformer.callbackName(remap), remap, new Type[]{Constants.TYPE_OBJECT, Constants.TYPE_STRING, remap, remap});
    }

    private static Type remap(Type type2) {
        switch (type2.getSort()) {
            case 9: 
            case 10: {
                return Constants.TYPE_OBJECT;
            }
        }
        return type2;
    }

    private static String callbackName(Type type2) {
        return type2 == Constants.TYPE_OBJECT ? "Object" : TypeUtils.upperFirst(TypeUtils.getClassName(type2));
    }
}

