/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.transform.impl;

import java.util.HashMap;
import java.util.Map;
import org.springframework.asm.Label;
import org.springframework.asm.Type;
import org.springframework.cglib.core.CodeEmitter;
import org.springframework.cglib.core.CodeGenerationException;
import org.springframework.cglib.core.Constants;
import org.springframework.cglib.core.EmitUtils;
import org.springframework.cglib.core.ObjectSwitchCallback;
import org.springframework.cglib.core.ProcessSwitchCallback;
import org.springframework.cglib.core.Signature;
import org.springframework.cglib.core.TypeUtils;
import org.springframework.cglib.transform.ClassEmitterTransformer;

public class FieldProviderTransformer
extends ClassEmitterTransformer {
    private static final String FIELD_NAMES = "CGLIB$FIELD_NAMES";
    private static final String FIELD_TYPES = "CGLIB$FIELD_TYPES";
    private static final Type FIELD_PROVIDER = TypeUtils.parseType("org.springframework.cglib.transform.impl.FieldProvider");
    private static final Type ILLEGAL_ARGUMENT_EXCEPTION = TypeUtils.parseType("IllegalArgumentException");
    private static final Signature PROVIDER_GET = TypeUtils.parseSignature("Object getField(String)");
    private static final Signature PROVIDER_SET = TypeUtils.parseSignature("void setField(String, Object)");
    private static final Signature PROVIDER_SET_BY_INDEX = TypeUtils.parseSignature("void setField(int, Object)");
    private static final Signature PROVIDER_GET_BY_INDEX = TypeUtils.parseSignature("Object getField(int)");
    private static final Signature PROVIDER_GET_TYPES = TypeUtils.parseSignature("Class[] getFieldTypes()");
    private static final Signature PROVIDER_GET_NAMES = TypeUtils.parseSignature("String[] getFieldNames()");
    private int access;
    private Map fields;

    public void begin_class(int version, int access, String className, Type superType, Type[] interfaces, String sourceFile) {
        if (!TypeUtils.isAbstract(access)) {
            interfaces = TypeUtils.add(interfaces, FIELD_PROVIDER);
        }
        this.access = access;
        this.fields = new HashMap();
        super.begin_class(version, access, className, superType, interfaces, sourceFile);
    }

    public void declare_field(int access, String name2, Type type2, Object value) {
        super.declare_field(access, name2, type2, value);
        if (!TypeUtils.isStatic(access)) {
            this.fields.put(name2, type2);
        }
    }

    public void end_class() {
        if (!TypeUtils.isInterface(this.access)) {
            try {
                this.generate();
            }
            catch (RuntimeException e2) {
                throw e2;
            }
            catch (Exception e3) {
                throw new CodeGenerationException(e3);
            }
        }
        super.end_class();
    }

    private void generate() throws Exception {
        String[] names = this.fields.keySet().toArray(new String[this.fields.size()]);
        int[] indexes = new int[names.length];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = i;
        }
        super.declare_field(26, FIELD_NAMES, Constants.TYPE_STRING_ARRAY, null);
        super.declare_field(26, FIELD_TYPES, Constants.TYPE_CLASS_ARRAY, null);
        this.initFieldProvider(names);
        this.getNames();
        this.getTypes();
        this.getField(names);
        this.setField(names);
        this.setByIndex(names, indexes);
        this.getByIndex(names, indexes);
    }

    private void initFieldProvider(String[] names) {
        CodeEmitter e2 = this.getStaticHook();
        EmitUtils.push_object(e2, names);
        e2.putstatic(this.getClassType(), FIELD_NAMES, Constants.TYPE_STRING_ARRAY);
        e2.push(names.length);
        e2.newarray(Constants.TYPE_CLASS);
        e2.dup();
        for (int i = 0; i < names.length; ++i) {
            e2.dup();
            e2.push(i);
            Type type2 = (Type)this.fields.get(names[i]);
            EmitUtils.load_class(e2, type2);
            e2.aastore();
        }
        e2.putstatic(this.getClassType(), FIELD_TYPES, Constants.TYPE_CLASS_ARRAY);
    }

    private void getNames() {
        CodeEmitter e2 = super.begin_method(1, PROVIDER_GET_NAMES, null);
        e2.getstatic(this.getClassType(), FIELD_NAMES, Constants.TYPE_STRING_ARRAY);
        e2.return_value();
        e2.end_method();
    }

    private void getTypes() {
        CodeEmitter e2 = super.begin_method(1, PROVIDER_GET_TYPES, null);
        e2.getstatic(this.getClassType(), FIELD_TYPES, Constants.TYPE_CLASS_ARRAY);
        e2.return_value();
        e2.end_method();
    }

    private void setByIndex(final String[] names, int[] indexes) throws Exception {
        final CodeEmitter e2 = super.begin_method(1, PROVIDER_SET_BY_INDEX, null);
        e2.load_this();
        e2.load_arg(1);
        e2.load_arg(0);
        e2.process_switch(indexes, new ProcessSwitchCallback(){

            public void processCase(int key2, Label end) throws Exception {
                Type type2 = (Type)FieldProviderTransformer.this.fields.get(names[key2]);
                e2.unbox(type2);
                e2.putfield(names[key2]);
                e2.return_value();
            }

            public void processDefault() throws Exception {
                e2.throw_exception(ILLEGAL_ARGUMENT_EXCEPTION, "Unknown field index");
            }
        });
        e2.end_method();
    }

    private void getByIndex(final String[] names, int[] indexes) throws Exception {
        final CodeEmitter e2 = super.begin_method(1, PROVIDER_GET_BY_INDEX, null);
        e2.load_this();
        e2.load_arg(0);
        e2.process_switch(indexes, new ProcessSwitchCallback(){

            public void processCase(int key2, Label end) throws Exception {
                Type type2 = (Type)FieldProviderTransformer.this.fields.get(names[key2]);
                e2.getfield(names[key2]);
                e2.box(type2);
                e2.return_value();
            }

            public void processDefault() throws Exception {
                e2.throw_exception(ILLEGAL_ARGUMENT_EXCEPTION, "Unknown field index");
            }
        });
        e2.end_method();
    }

    private void getField(String[] names) throws Exception {
        final CodeEmitter e2 = this.begin_method(1, PROVIDER_GET, null);
        e2.load_this();
        e2.load_arg(0);
        EmitUtils.string_switch(e2, names, 1, new ObjectSwitchCallback(){

            public void processCase(Object key2, Label end) {
                Type type2 = (Type)FieldProviderTransformer.this.fields.get(key2);
                e2.getfield((String)key2);
                e2.box(type2);
                e2.return_value();
            }

            public void processDefault() {
                e2.throw_exception(ILLEGAL_ARGUMENT_EXCEPTION, "Unknown field name");
            }
        });
        e2.end_method();
    }

    private void setField(String[] names) throws Exception {
        final CodeEmitter e2 = this.begin_method(1, PROVIDER_SET, null);
        e2.load_this();
        e2.load_arg(1);
        e2.load_arg(0);
        EmitUtils.string_switch(e2, names, 1, new ObjectSwitchCallback(){

            public void processCase(Object key2, Label end) {
                Type type2 = (Type)FieldProviderTransformer.this.fields.get(key2);
                e2.unbox(type2);
                e2.putfield((String)key2);
                e2.return_value();
            }

            public void processDefault() {
                e2.throw_exception(ILLEGAL_ARGUMENT_EXCEPTION, "Unknown field name");
            }
        });
        e2.end_method();
    }
}

