/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.transform;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import org.springframework.asm.Attribute;
import org.springframework.asm.ClassReader;
import org.springframework.cglib.core.ClassGenerator;
import org.springframework.cglib.core.CodeGenerationException;
import org.springframework.cglib.core.DebuggingClassWriter;
import org.springframework.cglib.transform.ClassFilter;
import org.springframework.cglib.transform.ClassReaderGenerator;

public abstract class AbstractClassLoader
extends ClassLoader {
    private ClassFilter filter;
    private ClassLoader classPath;
    private static ProtectionDomain DOMAIN = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return (class$net$sf$cglib$transform$AbstractClassLoader == null ? (class$net$sf$cglib$transform$AbstractClassLoader = AbstractClassLoader.class$("org.springframework.cglib.transform.AbstractClassLoader")) : class$net$sf$cglib$transform$AbstractClassLoader).getProtectionDomain();
        }
    });
    static /* synthetic */ Class class$net$sf$cglib$transform$AbstractClassLoader;

    protected AbstractClassLoader(ClassLoader parent, ClassLoader classPath, ClassFilter filter2) {
        super(parent);
        this.filter = filter2;
        this.classPath = classPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class loadClass(String name2) throws ClassNotFoundException {
        ClassReader r;
        Class<?> loaded = this.findLoadedClass(name2);
        if (loaded != null && loaded.getClassLoader() == this) {
            return loaded;
        }
        if (!this.filter.accept(name2)) {
            return super.loadClass(name2);
        }
        try {
            InputStream is2 = this.classPath.getResourceAsStream(name2.replace('.', '/') + ".class");
            if (is2 == null) {
                throw new ClassNotFoundException(name2);
            }
            try {
                r = new ClassReader(is2);
            }
            finally {
                is2.close();
            }
        }
        catch (IOException e2) {
            throw new ClassNotFoundException(name2 + ":" + e2.getMessage());
        }
        try {
            DebuggingClassWriter w = new DebuggingClassWriter(1);
            this.getGenerator(r).generateClass(w);
            byte[] b = w.toByteArray();
            Class<?> c = super.defineClass(name2, b, 0, b.length, DOMAIN);
            this.postProcess(c);
            return c;
        }
        catch (RuntimeException e3) {
            throw e3;
        }
        catch (Error e4) {
            throw e4;
        }
        catch (Exception e5) {
            throw new CodeGenerationException(e5);
        }
    }

    protected ClassGenerator getGenerator(ClassReader r) {
        return new ClassReaderGenerator(r, this.attributes(), this.getFlags());
    }

    protected int getFlags() {
        return 0;
    }

    protected Attribute[] attributes() {
        return null;
    }

    protected void postProcess(Class c) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

