/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.springframework.asm.ClassVisitor;
import org.springframework.asm.Type;
import org.springframework.cglib.core.AbstractClassGenerator;
import org.springframework.cglib.core.ClassEmitter;
import org.springframework.cglib.core.CodeEmitter;
import org.springframework.cglib.core.EmitUtils;
import org.springframework.cglib.core.KeyFactory;
import org.springframework.cglib.core.ReflectUtils;
import org.springframework.cglib.core.TypeUtils;

public abstract class ConstructorDelegate {
    private static final ConstructorKey KEY_FACTORY = (ConstructorKey)((Object)KeyFactory.create(class$net$sf$cglib$reflect$ConstructorDelegate$ConstructorKey == null ? (class$net$sf$cglib$reflect$ConstructorDelegate$ConstructorKey = ConstructorDelegate.class$("org.springframework.cglib.reflect.ConstructorDelegate$ConstructorKey")) : class$net$sf$cglib$reflect$ConstructorDelegate$ConstructorKey, KeyFactory.CLASS_BY_NAME));
    static /* synthetic */ Class class$net$sf$cglib$reflect$ConstructorDelegate$ConstructorKey;
    static /* synthetic */ Class class$net$sf$cglib$reflect$ConstructorDelegate;

    protected ConstructorDelegate() {
    }

    public static ConstructorDelegate create(Class targetClass, Class iface) {
        Generator gen = new Generator();
        gen.setTargetClass(targetClass);
        gen.setInterface(iface);
        return gen.create();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Generator
    extends AbstractClassGenerator {
        private static final AbstractClassGenerator.Source SOURCE = new AbstractClassGenerator.Source((class$net$sf$cglib$reflect$ConstructorDelegate == null ? (class$net$sf$cglib$reflect$ConstructorDelegate = ConstructorDelegate.class$("org.springframework.cglib.reflect.ConstructorDelegate")) : class$net$sf$cglib$reflect$ConstructorDelegate).getName());
        private static final Type CONSTRUCTOR_DELEGATE = TypeUtils.parseType("org.springframework.cglib.reflect.ConstructorDelegate");
        private Class iface;
        private Class targetClass;

        public Generator() {
            super(SOURCE);
        }

        public void setInterface(Class iface) {
            this.iface = iface;
        }

        public void setTargetClass(Class targetClass) {
            this.targetClass = targetClass;
        }

        public ConstructorDelegate create() {
            this.setNamePrefix(this.targetClass.getName());
            Object key2 = KEY_FACTORY.newInstance(this.iface.getName(), this.targetClass.getName());
            return (ConstructorDelegate)super.create(key2);
        }

        protected ClassLoader getDefaultClassLoader() {
            return this.targetClass.getClassLoader();
        }

        public void generateClass(ClassVisitor v) {
            Constructor constructor;
            this.setNamePrefix(this.targetClass.getName());
            Method newInstance = ReflectUtils.findNewInstance(this.iface);
            if (!newInstance.getReturnType().isAssignableFrom(this.targetClass)) {
                throw new IllegalArgumentException("incompatible return type");
            }
            try {
                constructor = this.targetClass.getDeclaredConstructor(newInstance.getParameterTypes());
            }
            catch (NoSuchMethodException e2) {
                throw new IllegalArgumentException("interface does not match any known constructor");
            }
            ClassEmitter ce = new ClassEmitter(v);
            ce.begin_class(46, 1, this.getClassName(), CONSTRUCTOR_DELEGATE, new Type[]{Type.getType(this.iface)}, "<generated>");
            Type declaring = Type.getType(constructor.getDeclaringClass());
            EmitUtils.null_constructor(ce);
            CodeEmitter e3 = ce.begin_method(1, ReflectUtils.getSignature(newInstance), ReflectUtils.getExceptionTypes(newInstance));
            e3.new_instance(declaring);
            e3.dup();
            e3.load_args();
            e3.invoke_constructor(declaring, ReflectUtils.getSignature(constructor));
            e3.return_value();
            e3.end_method();
            ce.end_class();
        }

        protected Object firstInstance(Class type2) {
            return ReflectUtils.newInstance(type2);
        }

        protected Object nextInstance(Object instance) {
            return instance;
        }
    }

    static interface ConstructorKey {
        public Object newInstance(String var1, String var2);
    }
}

