/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.proxy;

import java.util.Iterator;
import java.util.List;
import org.springframework.asm.Type;
import org.springframework.cglib.core.ClassEmitter;
import org.springframework.cglib.core.CodeEmitter;
import org.springframework.cglib.core.MethodInfo;
import org.springframework.cglib.core.Signature;
import org.springframework.cglib.core.TypeUtils;
import org.springframework.cglib.proxy.CallbackGenerator;

class DispatcherGenerator
implements CallbackGenerator {
    public static final DispatcherGenerator INSTANCE = new DispatcherGenerator(false);
    public static final DispatcherGenerator PROXY_REF_INSTANCE = new DispatcherGenerator(true);
    private static final Type DISPATCHER = TypeUtils.parseType("org.springframework.cglib.proxy.Dispatcher");
    private static final Type PROXY_REF_DISPATCHER = TypeUtils.parseType("org.springframework.cglib.proxy.ProxyRefDispatcher");
    private static final Signature LOAD_OBJECT = TypeUtils.parseSignature("Object loadObject()");
    private static final Signature PROXY_REF_LOAD_OBJECT = TypeUtils.parseSignature("Object loadObject(Object)");
    private boolean proxyRef;

    private DispatcherGenerator(boolean proxyRef) {
        this.proxyRef = proxyRef;
    }

    public void generate(ClassEmitter ce, CallbackGenerator.Context context, List methods2) {
        Iterator it = methods2.iterator();
        while (it.hasNext()) {
            MethodInfo method = (MethodInfo)it.next();
            if (TypeUtils.isProtected(method.getModifiers())) continue;
            CodeEmitter e2 = context.beginMethod(ce, method);
            context.emitCallback(e2, context.getIndex(method));
            if (this.proxyRef) {
                e2.load_this();
                e2.invoke_interface(PROXY_REF_DISPATCHER, PROXY_REF_LOAD_OBJECT);
            } else {
                e2.invoke_interface(DISPATCHER, LOAD_OBJECT);
            }
            e2.checkcast(method.getClassInfo().getType());
            e2.load_args();
            e2.invoke(method);
            e2.return_value();
            e2.end_method();
        }
    }

    public void generateStatic(CodeEmitter e2, CallbackGenerator.Context context, List methods2) {
    }
}

