/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.beans;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import org.springframework.asm.ClassVisitor;
import org.springframework.asm.Type;
import org.springframework.cglib.core.AbstractClassGenerator;
import org.springframework.cglib.core.ClassEmitter;
import org.springframework.cglib.core.CodeEmitter;
import org.springframework.cglib.core.EmitUtils;
import org.springframework.cglib.core.MethodInfo;
import org.springframework.cglib.core.ReflectUtils;
import org.springframework.cglib.core.Signature;
import org.springframework.cglib.core.TypeUtils;

public class ImmutableBean {
    private static final Type ILLEGAL_STATE_EXCEPTION = TypeUtils.parseType("IllegalStateException");
    private static final Signature CSTRUCT_OBJECT = TypeUtils.parseConstructor("Object");
    private static final Class[] OBJECT_CLASSES = new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = ImmutableBean.class$("java.lang.Object")) : class$java$lang$Object};
    private static final String FIELD_NAME = "CGLIB$RWBean";
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$net$sf$cglib$beans$ImmutableBean;

    private ImmutableBean() {
    }

    public static Object create(Object bean2) {
        Generator gen = new Generator();
        gen.setBean(bean2);
        return gen.create();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Generator
    extends AbstractClassGenerator {
        private static final AbstractClassGenerator.Source SOURCE = new AbstractClassGenerator.Source((class$net$sf$cglib$beans$ImmutableBean == null ? (class$net$sf$cglib$beans$ImmutableBean = ImmutableBean.class$("org.springframework.cglib.beans.ImmutableBean")) : class$net$sf$cglib$beans$ImmutableBean).getName());
        private Object bean;
        private Class target;

        public Generator() {
            super(SOURCE);
        }

        public void setBean(Object bean2) {
            this.bean = bean2;
            this.target = bean2.getClass();
        }

        protected ClassLoader getDefaultClassLoader() {
            return this.target.getClassLoader();
        }

        public Object create() {
            String name2 = this.target.getName();
            this.setNamePrefix(name2);
            return super.create(name2);
        }

        public void generateClass(ClassVisitor v) {
            int i;
            Type targetType = Type.getType(this.target);
            ClassEmitter ce = new ClassEmitter(v);
            ce.begin_class(46, 1, this.getClassName(), targetType, null, "<generated>");
            ce.declare_field(18, ImmutableBean.FIELD_NAME, targetType, null);
            CodeEmitter e2 = ce.begin_method(1, CSTRUCT_OBJECT, null);
            e2.load_this();
            e2.super_invoke_constructor();
            e2.load_this();
            e2.load_arg(0);
            e2.checkcast(targetType);
            e2.putfield(ImmutableBean.FIELD_NAME);
            e2.return_value();
            e2.end_method();
            PropertyDescriptor[] descriptors = ReflectUtils.getBeanProperties(this.target);
            Method[] getters = ReflectUtils.getPropertyMethods(descriptors, true, false);
            Method[] setters = ReflectUtils.getPropertyMethods(descriptors, false, true);
            for (i = 0; i < getters.length; ++i) {
                MethodInfo getter = ReflectUtils.getMethodInfo(getters[i]);
                e2 = EmitUtils.begin_method(ce, getter, 1);
                e2.load_this();
                e2.getfield(ImmutableBean.FIELD_NAME);
                e2.invoke(getter);
                e2.return_value();
                e2.end_method();
            }
            for (i = 0; i < setters.length; ++i) {
                MethodInfo setter = ReflectUtils.getMethodInfo(setters[i]);
                e2 = EmitUtils.begin_method(ce, setter, 1);
                e2.throw_exception(ILLEGAL_STATE_EXCEPTION, "Bean is immutable");
                e2.end_method();
            }
            ce.end_class();
        }

        protected Object firstInstance(Class type2) {
            return ReflectUtils.newInstance(type2, OBJECT_CLASSES, new Object[]{this.bean});
        }

        protected Object nextInstance(Object instance) {
            return this.firstInstance(instance.getClass());
        }
    }
}

