/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.beans;

import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.springframework.asm.ClassVisitor;
import org.springframework.asm.Label;
import org.springframework.asm.Type;
import org.springframework.cglib.core.ClassEmitter;
import org.springframework.cglib.core.CodeEmitter;
import org.springframework.cglib.core.Constants;
import org.springframework.cglib.core.EmitUtils;
import org.springframework.cglib.core.MethodInfo;
import org.springframework.cglib.core.ObjectSwitchCallback;
import org.springframework.cglib.core.ReflectUtils;
import org.springframework.cglib.core.Signature;
import org.springframework.cglib.core.TypeUtils;

class BeanMapEmitter
extends ClassEmitter {
    private static final Type BEAN_MAP = TypeUtils.parseType("org.springframework.cglib.beans.BeanMap");
    private static final Type FIXED_KEY_SET = TypeUtils.parseType("org.springframework.cglib.beans.FixedKeySet");
    private static final Signature CSTRUCT_OBJECT = TypeUtils.parseConstructor("Object");
    private static final Signature CSTRUCT_STRING_ARRAY = TypeUtils.parseConstructor("String[]");
    private static final Signature BEAN_MAP_GET = TypeUtils.parseSignature("Object get(Object, Object)");
    private static final Signature BEAN_MAP_PUT = TypeUtils.parseSignature("Object put(Object, Object, Object)");
    private static final Signature KEY_SET = TypeUtils.parseSignature("java.util.Set keySet()");
    private static final Signature NEW_INSTANCE = new Signature("newInstance", BEAN_MAP, new Type[]{Constants.TYPE_OBJECT});
    private static final Signature GET_PROPERTY_TYPE = TypeUtils.parseSignature("Class getPropertyType(String)");

    public BeanMapEmitter(ClassVisitor v, String className, Class type2, int require2) {
        super(v);
        this.begin_class(46, 1, className, BEAN_MAP, null, "<generated>");
        EmitUtils.null_constructor(this);
        EmitUtils.factory_method(this, NEW_INSTANCE);
        this.generateConstructor();
        Map getters = this.makePropertyMap(ReflectUtils.getBeanGetters(type2));
        Map setters = this.makePropertyMap(ReflectUtils.getBeanSetters(type2));
        HashMap allProps = new HashMap();
        allProps.putAll(getters);
        allProps.putAll(setters);
        if (require2 != 0) {
            Iterator it = allProps.keySet().iterator();
            while (it.hasNext()) {
                String name2 = (String)it.next();
                if (((require2 & 1) == 0 || getters.containsKey(name2)) && ((require2 & 2) == 0 || setters.containsKey(name2))) continue;
                it.remove();
                getters.remove(name2);
                setters.remove(name2);
            }
        }
        this.generateGet(type2, getters);
        this.generatePut(type2, setters);
        String[] allNames = this.getNames(allProps);
        this.generateKeySet(allNames);
        this.generateGetPropertyType(allProps, allNames);
        this.end_class();
    }

    private Map makePropertyMap(PropertyDescriptor[] props) {
        HashMap<String, PropertyDescriptor> names = new HashMap<String, PropertyDescriptor>();
        for (int i = 0; i < props.length; ++i) {
            names.put(props[i].getName(), props[i]);
        }
        return names;
    }

    private String[] getNames(Map propertyMap) {
        return propertyMap.keySet().toArray(new String[propertyMap.size()]);
    }

    private void generateConstructor() {
        CodeEmitter e2 = this.begin_method(1, CSTRUCT_OBJECT, null);
        e2.load_this();
        e2.load_arg(0);
        e2.super_invoke_constructor(CSTRUCT_OBJECT);
        e2.return_value();
        e2.end_method();
    }

    private void generateGet(Class type2, final Map getters) {
        final CodeEmitter e2 = this.begin_method(1, BEAN_MAP_GET, null);
        e2.load_arg(0);
        e2.checkcast(Type.getType(type2));
        e2.load_arg(1);
        e2.checkcast(Constants.TYPE_STRING);
        EmitUtils.string_switch(e2, this.getNames(getters), 1, new ObjectSwitchCallback(){

            public void processCase(Object key2, Label end) {
                PropertyDescriptor pd = (PropertyDescriptor)getters.get(key2);
                MethodInfo method = ReflectUtils.getMethodInfo(pd.getReadMethod());
                e2.invoke(method);
                e2.box(method.getSignature().getReturnType());
                e2.return_value();
            }

            public void processDefault() {
                e2.aconst_null();
                e2.return_value();
            }
        });
        e2.end_method();
    }

    private void generatePut(Class type2, final Map setters) {
        final CodeEmitter e2 = this.begin_method(1, BEAN_MAP_PUT, null);
        e2.load_arg(0);
        e2.checkcast(Type.getType(type2));
        e2.load_arg(1);
        e2.checkcast(Constants.TYPE_STRING);
        EmitUtils.string_switch(e2, this.getNames(setters), 1, new ObjectSwitchCallback(){

            public void processCase(Object key2, Label end) {
                PropertyDescriptor pd = (PropertyDescriptor)setters.get(key2);
                if (pd.getReadMethod() == null) {
                    e2.aconst_null();
                } else {
                    MethodInfo read2 = ReflectUtils.getMethodInfo(pd.getReadMethod());
                    e2.dup();
                    e2.invoke(read2);
                    e2.box(read2.getSignature().getReturnType());
                }
                e2.swap();
                e2.load_arg(2);
                MethodInfo write2 = ReflectUtils.getMethodInfo(pd.getWriteMethod());
                e2.unbox(write2.getSignature().getArgumentTypes()[0]);
                e2.invoke(write2);
                e2.return_value();
            }

            public void processDefault() {
            }
        });
        e2.aconst_null();
        e2.return_value();
        e2.end_method();
    }

    private void generateKeySet(String[] allNames) {
        this.declare_field(10, "keys", FIXED_KEY_SET, null);
        CodeEmitter e2 = this.begin_static();
        e2.new_instance(FIXED_KEY_SET);
        e2.dup();
        EmitUtils.push_array(e2, allNames);
        e2.invoke_constructor(FIXED_KEY_SET, CSTRUCT_STRING_ARRAY);
        e2.putfield("keys");
        e2.return_value();
        e2.end_method();
        e2 = this.begin_method(1, KEY_SET, null);
        e2.load_this();
        e2.getfield("keys");
        e2.return_value();
        e2.end_method();
    }

    private void generateGetPropertyType(final Map allProps, String[] allNames) {
        final CodeEmitter e2 = this.begin_method(1, GET_PROPERTY_TYPE, null);
        e2.load_arg(0);
        EmitUtils.string_switch(e2, allNames, 1, new ObjectSwitchCallback(){

            public void processCase(Object key2, Label end) {
                PropertyDescriptor pd = (PropertyDescriptor)allProps.get(key2);
                EmitUtils.load_class(e2, Type.getType(pd.getPropertyType()));
                e2.return_value();
            }

            public void processDefault() {
                e2.aconst_null();
                e2.return_value();
            }
        });
        e2.end_method();
    }
}

