/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.interceptor;

import org.springframework.cache.Cache;
import org.springframework.cache.interceptor.CacheErrorHandler;
import org.springframework.cache.interceptor.SimpleCacheErrorHandler;
import org.springframework.util.Assert;

public abstract class AbstractCacheInvoker {
    private CacheErrorHandler errorHandler;

    protected AbstractCacheInvoker(CacheErrorHandler errorHandler) {
        Assert.notNull("ErrorHandler must not be null");
        this.errorHandler = errorHandler;
    }

    protected AbstractCacheInvoker() {
        this(new SimpleCacheErrorHandler());
    }

    public void setErrorHandler(CacheErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public CacheErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    protected Cache.ValueWrapper doGet(Cache cache, Object key2) {
        try {
            return cache.get(key2);
        }
        catch (RuntimeException e2) {
            this.getErrorHandler().handleCacheGetError(e2, cache, key2);
            return null;
        }
    }

    protected void doPut(Cache cache, Object key2, Object result) {
        try {
            cache.put(key2, result);
        }
        catch (RuntimeException e2) {
            this.getErrorHandler().handleCachePutError(e2, cache, key2, result);
        }
    }

    protected void doEvict(Cache cache, Object key2) {
        try {
            cache.evict(key2);
        }
        catch (RuntimeException e2) {
            this.getErrorHandler().handleCacheEvictError(e2, cache, key2);
        }
    }

    protected void doClear(Cache cache) {
        try {
            cache.clear();
        }
        catch (RuntimeException e2) {
            this.getErrorHandler().handleCacheClearError(e2, cache);
        }
    }
}

