/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.xml;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ClassPathResource;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class BeansDtdResolver
implements EntityResolver {
    private static final String DTD_EXTENSION = ".dtd";
    private static final String DTD_FILENAME = "spring-beans-2.0";
    private static final String DTD_NAME = "spring-beans";
    private static final Log logger = LogFactory.getLog(BeansDtdResolver.class);

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws IOException {
        block7: {
            if (logger.isTraceEnabled()) {
                logger.trace("Trying to resolve XML entity with public ID [" + publicId + "] and system ID [" + systemId + "]");
            }
            if (systemId != null && systemId.endsWith(DTD_EXTENSION)) {
                int lastPathSeparator = systemId.lastIndexOf("/");
                int dtdNameStart = systemId.indexOf(DTD_NAME);
                if (dtdNameStart > lastPathSeparator) {
                    String dtdFile = "spring-beans-2.0.dtd";
                    if (logger.isTraceEnabled()) {
                        logger.trace("Trying to locate [" + dtdFile + "] in Spring jar on classpath");
                    }
                    try {
                        ClassPathResource resource2 = new ClassPathResource(dtdFile, this.getClass());
                        InputSource source2 = new InputSource(resource2.getInputStream());
                        source2.setPublicId(publicId);
                        source2.setSystemId(systemId);
                        if (logger.isDebugEnabled()) {
                            logger.debug("Found beans DTD [" + systemId + "] in classpath: " + dtdFile);
                        }
                        return source2;
                    }
                    catch (IOException ex) {
                        if (!logger.isDebugEnabled()) break block7;
                        logger.debug("Could not resolve beans DTD [" + systemId + "]: not found in classpath", ex);
                    }
                }
            }
        }
        return null;
    }

    public String toString() {
        return "EntityResolver for spring-beans DTD";
    }
}

