/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.BeanIsNotAFactoryException;
import org.springframework.beans.factory.BeanNotOfRequiredTypeException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.beans.factory.SmartFactoryBean;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.StringUtils;

public class StaticListableBeanFactory
implements ListableBeanFactory {
    private final Map<String, Object> beans = new HashMap<String, Object>();

    public void addBean(String name2, Object bean2) {
        this.beans.put(name2, bean2);
    }

    @Override
    public Object getBean(String name2) throws BeansException {
        String beanName = BeanFactoryUtils.transformedBeanName(name2);
        Object bean2 = this.beans.get(beanName);
        if (bean2 == null) {
            throw new NoSuchBeanDefinitionException(beanName, "Defined beans are [" + StringUtils.collectionToCommaDelimitedString(this.beans.keySet()) + "]");
        }
        if (BeanFactoryUtils.isFactoryDereference(name2) && !(bean2 instanceof FactoryBean)) {
            throw new BeanIsNotAFactoryException(beanName, bean2.getClass());
        }
        if (bean2 instanceof FactoryBean && !BeanFactoryUtils.isFactoryDereference(name2)) {
            try {
                return ((FactoryBean)bean2).getObject();
            }
            catch (Exception ex) {
                throw new BeanCreationException(beanName, "FactoryBean threw exception on object creation", ex);
            }
        }
        return bean2;
    }

    @Override
    public <T> T getBean(String name2, Class<T> requiredType) throws BeansException {
        Object bean2 = this.getBean(name2);
        if (requiredType != null && !requiredType.isAssignableFrom(bean2.getClass())) {
            throw new BeanNotOfRequiredTypeException(name2, requiredType, bean2.getClass());
        }
        return (T)bean2;
    }

    @Override
    public <T> T getBean(Class<T> requiredType) throws BeansException {
        String[] beanNames = this.getBeanNamesForType(requiredType);
        if (beanNames.length == 1) {
            return this.getBean(beanNames[0], requiredType);
        }
        if (beanNames.length > 1) {
            throw new NoUniqueBeanDefinitionException(requiredType, beanNames);
        }
        throw new NoSuchBeanDefinitionException(requiredType);
    }

    @Override
    public Object getBean(String name2, Object ... args) throws BeansException {
        if (args != null) {
            throw new UnsupportedOperationException("StaticListableBeanFactory does not support explicit bean creation arguments");
        }
        return this.getBean(name2);
    }

    @Override
    public <T> T getBean(Class<T> requiredType, Object ... args) throws BeansException {
        if (args != null) {
            throw new UnsupportedOperationException("StaticListableBeanFactory does not support explicit bean creation arguments");
        }
        return this.getBean(requiredType);
    }

    @Override
    public boolean containsBean(String name2) {
        return this.beans.containsKey(name2);
    }

    @Override
    public boolean isSingleton(String name2) throws NoSuchBeanDefinitionException {
        Object bean2 = this.getBean(name2);
        return bean2 instanceof FactoryBean && ((FactoryBean)bean2).isSingleton();
    }

    @Override
    public boolean isPrototype(String name2) throws NoSuchBeanDefinitionException {
        Object bean2 = this.getBean(name2);
        return bean2 instanceof SmartFactoryBean && ((SmartFactoryBean)bean2).isPrototype() || bean2 instanceof FactoryBean && !((FactoryBean)bean2).isSingleton();
    }

    @Override
    public boolean isTypeMatch(String name2, ResolvableType typeToMatch) throws NoSuchBeanDefinitionException {
        Class<?> type2 = this.getType(name2);
        return type2 != null && typeToMatch.isAssignableFrom(type2);
    }

    @Override
    public boolean isTypeMatch(String name2, Class<?> typeToMatch) throws NoSuchBeanDefinitionException {
        Class<?> type2 = this.getType(name2);
        return typeToMatch == null || type2 != null && typeToMatch.isAssignableFrom(type2);
    }

    @Override
    public Class<?> getType(String name2) throws NoSuchBeanDefinitionException {
        String beanName = BeanFactoryUtils.transformedBeanName(name2);
        Object bean2 = this.beans.get(beanName);
        if (bean2 == null) {
            throw new NoSuchBeanDefinitionException(beanName, "Defined beans are [" + StringUtils.collectionToCommaDelimitedString(this.beans.keySet()) + "]");
        }
        if (bean2 instanceof FactoryBean && !BeanFactoryUtils.isFactoryDereference(name2)) {
            return ((FactoryBean)bean2).getObjectType();
        }
        return bean2.getClass();
    }

    @Override
    public String[] getAliases(String name2) {
        return new String[0];
    }

    @Override
    public boolean containsBeanDefinition(String name2) {
        return this.beans.containsKey(name2);
    }

    @Override
    public int getBeanDefinitionCount() {
        return this.beans.size();
    }

    @Override
    public String[] getBeanDefinitionNames() {
        return StringUtils.toStringArray(this.beans.keySet());
    }

    @Override
    public String[] getBeanNamesForType(ResolvableType type2) {
        boolean isFactoryType = type2 != null && FactoryBean.class.isAssignableFrom(type2.getRawClass());
        ArrayList<String> matches = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : this.beans.entrySet()) {
            String name2 = entry.getKey();
            Object beanInstance = entry.getValue();
            if (beanInstance instanceof FactoryBean && !isFactoryType) {
                Class<?> objectType = ((FactoryBean)beanInstance).getObjectType();
                if (objectType == null || type2 != null && !type2.isAssignableFrom(objectType)) continue;
                matches.add(name2);
                continue;
            }
            if (type2 != null && !type2.isInstance(beanInstance)) continue;
            matches.add(name2);
        }
        return StringUtils.toStringArray(matches);
    }

    @Override
    public String[] getBeanNamesForType(Class<?> type2) {
        return this.getBeanNamesForType(ResolvableType.forClass(type2));
    }

    @Override
    public String[] getBeanNamesForType(Class<?> type2, boolean includeNonSingletons, boolean allowEagerInit) {
        return this.getBeanNamesForType(ResolvableType.forClass(type2));
    }

    @Override
    public <T> Map<String, T> getBeansOfType(Class<T> type2) throws BeansException {
        return this.getBeansOfType(type2, true, true);
    }

    @Override
    public <T> Map<String, T> getBeansOfType(Class<T> type2, boolean includeNonSingletons, boolean allowEagerInit) throws BeansException {
        boolean isFactoryType = type2 != null && FactoryBean.class.isAssignableFrom(type2);
        HashMap<String, Object> matches = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.beans.entrySet()) {
            String beanName = entry.getKey();
            Object beanInstance = entry.getValue();
            if (beanInstance instanceof FactoryBean && !isFactoryType) {
                FactoryBean factory = (FactoryBean)beanInstance;
                Class<?> objectType = factory.getObjectType();
                if (!includeNonSingletons && !factory.isSingleton() || objectType == null || type2 != null && !type2.isAssignableFrom(objectType)) continue;
                matches.put(beanName, this.getBean(beanName, type2));
                continue;
            }
            if (type2 != null && !type2.isInstance(beanInstance)) continue;
            if (isFactoryType) {
                beanName = "&" + beanName;
            }
            matches.put(beanName, beanInstance);
        }
        return matches;
    }

    @Override
    public String[] getBeanNamesForAnnotation(Class<? extends Annotation> annotationType) {
        ArrayList<String> results = new ArrayList<String>();
        for (String beanName : this.beans.keySet()) {
            if (this.findAnnotationOnBean(beanName, annotationType) == null) continue;
            results.add(beanName);
        }
        return results.toArray(new String[results.size()]);
    }

    @Override
    public Map<String, Object> getBeansWithAnnotation(Class<? extends Annotation> annotationType) throws BeansException {
        LinkedHashMap<String, Object> results = new LinkedHashMap<String, Object>();
        for (String beanName : this.beans.keySet()) {
            if (this.findAnnotationOnBean(beanName, annotationType) == null) continue;
            results.put(beanName, this.getBean(beanName));
        }
        return results;
    }

    @Override
    public <A extends Annotation> A findAnnotationOnBean(String beanName, Class<A> annotationType) throws NoSuchBeanDefinitionException {
        return AnnotationUtils.findAnnotation(this.getType(beanName), annotationType);
    }
}

