/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Provider;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanCurrentlyInCreationException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.CannotLoadBeanClassException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.SmartFactoryBean;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.beans.factory.support.AutowireUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;
import org.springframework.beans.factory.support.ConstructorResolver;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.support.SimpleAutowireCandidateResolver;
import org.springframework.core.OrderComparator;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.lang.UsesJava8;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CompositeIterator;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class DefaultListableBeanFactory
extends AbstractAutowireCapableBeanFactory
implements ConfigurableListableBeanFactory,
BeanDefinitionRegistry,
Serializable {
    private static Class<?> javaUtilOptionalClass = null;
    private static Class<?> javaxInjectProviderClass = null;
    private static final Map<String, Reference<DefaultListableBeanFactory>> serializableFactories;
    private String serializationId;
    private boolean allowBeanDefinitionOverriding = true;
    private boolean allowEagerClassLoading = true;
    private Comparator<Object> dependencyComparator;
    private AutowireCandidateResolver autowireCandidateResolver = new SimpleAutowireCandidateResolver();
    private final Map<Class<?>, Object> resolvableDependencies = new HashMap(16);
    private final Map<String, BeanDefinition> beanDefinitionMap = new ConcurrentHashMap<String, BeanDefinition>(64);
    private final Map<Class<?>, String[]> allBeanNamesByType = new ConcurrentHashMap(64);
    private final Map<Class<?>, String[]> singletonBeanNamesByType = new ConcurrentHashMap(64);
    private final List<String> beanDefinitionNames = new ArrayList<String>(64);
    private final Set<String> manualSingletonNames = new LinkedHashSet<String>(16);
    private boolean configurationFrozen = false;
    private String[] frozenBeanDefinitionNames;

    public DefaultListableBeanFactory() {
    }

    public DefaultListableBeanFactory(BeanFactory parentBeanFactory) {
        super(parentBeanFactory);
    }

    public void setSerializationId(String serializationId) {
        if (serializationId != null) {
            serializableFactories.put(serializationId, new WeakReference<DefaultListableBeanFactory>(this));
        } else if (this.serializationId != null) {
            serializableFactories.remove(this.serializationId);
        }
        this.serializationId = serializationId;
    }

    public String getSerializationId() {
        return this.serializationId;
    }

    public void setAllowBeanDefinitionOverriding(boolean allowBeanDefinitionOverriding) {
        this.allowBeanDefinitionOverriding = allowBeanDefinitionOverriding;
    }

    public boolean isAllowBeanDefinitionOverriding() {
        return this.allowBeanDefinitionOverriding;
    }

    public void setAllowEagerClassLoading(boolean allowEagerClassLoading) {
        this.allowEagerClassLoading = allowEagerClassLoading;
    }

    public boolean isAllowEagerClassLoading() {
        return this.allowEagerClassLoading;
    }

    public void setDependencyComparator(Comparator<Object> dependencyComparator) {
        this.dependencyComparator = dependencyComparator;
    }

    public Comparator<Object> getDependencyComparator() {
        return this.dependencyComparator;
    }

    public void setAutowireCandidateResolver(final AutowireCandidateResolver autowireCandidateResolver) {
        Assert.notNull(autowireCandidateResolver, "AutowireCandidateResolver must not be null");
        if (autowireCandidateResolver instanceof BeanFactoryAware) {
            if (System.getSecurityManager() != null) {
                final DefaultListableBeanFactory target = this;
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        ((BeanFactoryAware)((Object)autowireCandidateResolver)).setBeanFactory(target);
                        return null;
                    }
                }, this.getAccessControlContext());
            } else {
                ((BeanFactoryAware)((Object)autowireCandidateResolver)).setBeanFactory(this);
            }
        }
        this.autowireCandidateResolver = autowireCandidateResolver;
    }

    public AutowireCandidateResolver getAutowireCandidateResolver() {
        return this.autowireCandidateResolver;
    }

    @Override
    public void copyConfigurationFrom(ConfigurableBeanFactory otherFactory) {
        super.copyConfigurationFrom(otherFactory);
        if (otherFactory instanceof DefaultListableBeanFactory) {
            DefaultListableBeanFactory otherListableFactory = (DefaultListableBeanFactory)otherFactory;
            this.allowBeanDefinitionOverriding = otherListableFactory.allowBeanDefinitionOverriding;
            this.allowEagerClassLoading = otherListableFactory.allowEagerClassLoading;
            this.autowireCandidateResolver = otherListableFactory.autowireCandidateResolver;
            this.resolvableDependencies.putAll(otherListableFactory.resolvableDependencies);
        }
    }

    @Override
    public <T> T getBean(Class<T> requiredType) throws BeansException {
        return this.getBean(requiredType, (Object[])null);
    }

    @Override
    public <T> T getBean(Class<T> requiredType, Object ... args) throws BeansException {
        Assert.notNull(requiredType, "Required type must not be null");
        String[] beanNames = this.getBeanNamesForType(requiredType);
        if (beanNames.length > 1) {
            ArrayList<String> autowireCandidates = new ArrayList<String>();
            for (String beanName : beanNames) {
                if (this.containsBeanDefinition(beanName) && !this.getBeanDefinition(beanName).isAutowireCandidate()) continue;
                autowireCandidates.add(beanName);
            }
            if (autowireCandidates.size() > 0) {
                beanNames = autowireCandidates.toArray(new String[autowireCandidates.size()]);
            }
        }
        if (beanNames.length == 1) {
            return this.getBean(beanNames[0], requiredType, args);
        }
        if (beanNames.length > 1) {
            HashMap<String, Object> candidates = new HashMap<String, Object>();
            for (String beanName : beanNames) {
                candidates.put(beanName, this.getBean(beanName, requiredType, args));
            }
            String primaryCandidate = this.determinePrimaryCandidate(candidates, requiredType);
            if (primaryCandidate != null) {
                return this.getBean(primaryCandidate, requiredType, args);
            }
            String priorityCandidate = this.determineHighestPriorityCandidate(candidates, requiredType);
            if (priorityCandidate != null) {
                return this.getBean(priorityCandidate, requiredType, args);
            }
            throw new NoUniqueBeanDefinitionException(requiredType, candidates.keySet());
        }
        if (this.getParentBeanFactory() != null) {
            return this.getParentBeanFactory().getBean(requiredType, args);
        }
        throw new NoSuchBeanDefinitionException(requiredType);
    }

    @Override
    public boolean containsBeanDefinition(String beanName) {
        Assert.notNull(beanName, "Bean name must not be null");
        return this.beanDefinitionMap.containsKey(beanName);
    }

    @Override
    public int getBeanDefinitionCount() {
        return this.beanDefinitionMap.size();
    }

    @Override
    public String[] getBeanDefinitionNames() {
        if (this.frozenBeanDefinitionNames != null) {
            return this.frozenBeanDefinitionNames;
        }
        return StringUtils.toStringArray(this.beanDefinitionNames);
    }

    @Override
    public String[] getBeanNamesForType(ResolvableType type2) {
        return this.doGetBeanNamesForType(type2, true, true);
    }

    @Override
    public String[] getBeanNamesForType(Class<?> type2) {
        return this.getBeanNamesForType(type2, true, true);
    }

    @Override
    public String[] getBeanNamesForType(Class<?> type2, boolean includeNonSingletons, boolean allowEagerInit) {
        if (!this.isConfigurationFrozen() || type2 == null || !allowEagerInit) {
            return this.doGetBeanNamesForType(ResolvableType.forRawClass(type2), includeNonSingletons, allowEagerInit);
        }
        Map<Class<?>, String[]> cache = includeNonSingletons ? this.allBeanNamesByType : this.singletonBeanNamesByType;
        String[] resolvedBeanNames = cache.get(type2);
        if (resolvedBeanNames != null) {
            return resolvedBeanNames;
        }
        resolvedBeanNames = this.doGetBeanNamesForType(ResolvableType.forRawClass(type2), includeNonSingletons, true);
        if (ClassUtils.isCacheSafe(type2, this.getBeanClassLoader())) {
            cache.put(type2, resolvedBeanNames);
        }
        return resolvedBeanNames;
    }

    private String[] doGetBeanNamesForType(ResolvableType type2, boolean includeNonSingletons, boolean allowEagerInit) {
        ArrayList<String> result = new ArrayList<String>();
        for (String beanName : this.beanDefinitionNames) {
            if (this.isAlias(beanName)) continue;
            try {
                boolean matchFound;
                RootBeanDefinition mbd = this.getMergedLocalBeanDefinition(beanName);
                if (mbd.isAbstract() || !allowEagerInit && (!mbd.hasBeanClass() && mbd.isLazyInit() && !this.isAllowEagerClassLoading() || this.requiresEagerInitForType(mbd.getFactoryBeanName()))) continue;
                boolean isFactoryBean = this.isFactoryBean(beanName, mbd);
                boolean bl = matchFound = !(!allowEagerInit && isFactoryBean && !this.containsSingleton(beanName) || !includeNonSingletons && !this.isSingleton(beanName) || !this.isTypeMatch(beanName, type2));
                if (!matchFound && isFactoryBean) {
                    beanName = "&" + beanName;
                    boolean bl2 = matchFound = (includeNonSingletons || mbd.isSingleton()) && this.isTypeMatch(beanName, type2);
                }
                if (!matchFound) continue;
                result.add(beanName);
            }
            catch (CannotLoadBeanClassException ex) {
                if (allowEagerInit) {
                    throw ex;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Ignoring bean class loading failure for bean '" + beanName + "'", ex);
                }
                this.onSuppressedException(ex);
            }
            catch (BeanDefinitionStoreException ex) {
                if (allowEagerInit) {
                    throw ex;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Ignoring unresolvable metadata in bean definition '" + beanName + "'", ex);
                }
                this.onSuppressedException(ex);
            }
        }
        for (String beanName : this.manualSingletonNames) {
            try {
                if (this.isFactoryBean(beanName)) {
                    if ((includeNonSingletons || this.isSingleton(beanName)) && this.isTypeMatch(beanName, type2)) {
                        result.add(beanName);
                        continue;
                    }
                    beanName = "&" + beanName;
                }
                if (!this.isTypeMatch(beanName, type2)) continue;
                result.add(beanName);
            }
            catch (NoSuchBeanDefinitionException ex) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Failed to check manually registered singleton with name '" + beanName + "'", ex);
            }
        }
        return StringUtils.toStringArray(result);
    }

    private boolean requiresEagerInitForType(String factoryBeanName) {
        return factoryBeanName != null && this.isFactoryBean(factoryBeanName) && !this.containsSingleton(factoryBeanName);
    }

    @Override
    public <T> Map<String, T> getBeansOfType(Class<T> type2) throws BeansException {
        return this.getBeansOfType(type2, true, true);
    }

    @Override
    public <T> Map<String, T> getBeansOfType(Class<T> type2, boolean includeNonSingletons, boolean allowEagerInit) throws BeansException {
        String[] beanNames = this.getBeanNamesForType(type2, includeNonSingletons, allowEagerInit);
        LinkedHashMap<String, T> result = new LinkedHashMap<String, T>(beanNames.length);
        for (String beanName : beanNames) {
            try {
                result.put(beanName, this.getBean(beanName, type2));
            }
            catch (BeanCreationException ex) {
                BeanCreationException bce;
                Throwable rootCause = ex.getMostSpecificCause();
                if (rootCause instanceof BeanCurrentlyInCreationException && this.isCurrentlyInCreation((bce = (BeanCreationException)rootCause).getBeanName())) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Ignoring match to currently created bean '" + beanName + "': " + ex.getMessage());
                    }
                    this.onSuppressedException(ex);
                    continue;
                }
                throw ex;
            }
        }
        return result;
    }

    @Override
    public String[] getBeanNamesForAnnotation(Class<? extends Annotation> annotationType) {
        ArrayList<String> results = new ArrayList<String>();
        for (String beanName : this.beanDefinitionNames) {
            BeanDefinition beanDefinition = this.getBeanDefinition(beanName);
            if (beanDefinition.isAbstract() || this.findAnnotationOnBean(beanName, annotationType) == null) continue;
            results.add(beanName);
        }
        for (String beanName : this.manualSingletonNames) {
            if (results.contains(beanName) || this.findAnnotationOnBean(beanName, annotationType) == null) continue;
            results.add(beanName);
        }
        return results.toArray(new String[results.size()]);
    }

    @Override
    public Map<String, Object> getBeansWithAnnotation(Class<? extends Annotation> annotationType) {
        String[] beanNames = this.getBeanNamesForAnnotation(annotationType);
        LinkedHashMap<String, Object> results = new LinkedHashMap<String, Object>(beanNames.length);
        for (String beanName : beanNames) {
            results.put(beanName, this.getBean(beanName));
        }
        return results;
    }

    @Override
    public <A extends Annotation> A findAnnotationOnBean(String beanName, Class<A> annotationType) throws NoSuchBeanDefinitionException {
        AbstractBeanDefinition abd;
        BeanDefinition bd;
        A ann = null;
        Class<?> beanType = this.getType(beanName);
        if (beanType != null) {
            ann = AnnotationUtils.findAnnotation(beanType, annotationType);
        }
        if (ann == null && this.containsBeanDefinition(beanName) && (bd = this.getMergedBeanDefinition(beanName)) instanceof AbstractBeanDefinition && (abd = (AbstractBeanDefinition)bd).hasBeanClass()) {
            ann = AnnotationUtils.findAnnotation(abd.getBeanClass(), annotationType);
        }
        return ann;
    }

    @Override
    public void registerResolvableDependency(Class<?> dependencyType, Object autowiredValue) {
        Assert.notNull(dependencyType, "Type must not be null");
        if (autowiredValue != null) {
            Assert.isTrue(autowiredValue instanceof ObjectFactory || dependencyType.isInstance(autowiredValue), "Value [" + autowiredValue + "] does not implement specified type [" + dependencyType.getName() + "]");
            this.resolvableDependencies.put(dependencyType, autowiredValue);
        }
    }

    @Override
    public boolean isAutowireCandidate(String beanName, DependencyDescriptor descriptor2) throws NoSuchBeanDefinitionException {
        return this.isAutowireCandidate(beanName, descriptor2, this.getAutowireCandidateResolver());
    }

    protected boolean isAutowireCandidate(String beanName, DependencyDescriptor descriptor2, AutowireCandidateResolver resolver) throws NoSuchBeanDefinitionException {
        String beanDefinitionName = BeanFactoryUtils.transformedBeanName(beanName);
        if (this.containsBeanDefinition(beanDefinitionName)) {
            return this.isAutowireCandidate(beanName, this.getMergedLocalBeanDefinition(beanDefinitionName), descriptor2, resolver);
        }
        if (this.containsSingleton(beanName)) {
            return this.isAutowireCandidate(beanName, new RootBeanDefinition(this.getType(beanName)), descriptor2, resolver);
        }
        if (this.getParentBeanFactory() instanceof DefaultListableBeanFactory) {
            return ((DefaultListableBeanFactory)this.getParentBeanFactory()).isAutowireCandidate(beanName, descriptor2, resolver);
        }
        if (this.getParentBeanFactory() instanceof ConfigurableListableBeanFactory) {
            return ((ConfigurableListableBeanFactory)this.getParentBeanFactory()).isAutowireCandidate(beanName, descriptor2);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isAutowireCandidate(String beanName, RootBeanDefinition mbd, DependencyDescriptor descriptor2, AutowireCandidateResolver resolver) {
        String beanDefinitionName = BeanFactoryUtils.transformedBeanName(beanName);
        this.resolveBeanClass(mbd, beanDefinitionName, new Class[0]);
        if (mbd.isFactoryMethodUnique) {
            boolean resolve2;
            Object object = mbd.constructorArgumentLock;
            synchronized (object) {
                resolve2 = mbd.resolvedConstructorOrFactoryMethod == null;
            }
            if (resolve2) {
                new ConstructorResolver(this).resolveFactoryMethodIfPossible(mbd);
            }
        }
        return resolver.isAutowireCandidate(new BeanDefinitionHolder(mbd, beanName, this.getAliases(beanDefinitionName)), descriptor2);
    }

    @Override
    public BeanDefinition getBeanDefinition(String beanName) throws NoSuchBeanDefinitionException {
        BeanDefinition bd = this.beanDefinitionMap.get(beanName);
        if (bd == null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("No bean named '" + beanName + "' found in " + this);
            }
            throw new NoSuchBeanDefinitionException(beanName);
        }
        return bd;
    }

    @Override
    public Iterator<String> getBeanNamesIterator() {
        CompositeIterator<String> iterator = new CompositeIterator<String>();
        iterator.add(this.beanDefinitionNames.iterator());
        iterator.add(this.manualSingletonNames.iterator());
        return iterator;
    }

    @Override
    public void clearMetadataCache() {
        super.clearMetadataCache();
        this.clearByTypeCache();
    }

    @Override
    public void freezeConfiguration() {
        this.configurationFrozen = true;
        this.frozenBeanDefinitionNames = StringUtils.toStringArray(this.beanDefinitionNames);
    }

    @Override
    public boolean isConfigurationFrozen() {
        return this.configurationFrozen;
    }

    @Override
    protected boolean isBeanEligibleForMetadataCaching(String beanName) {
        return this.configurationFrozen || super.isBeanEligibleForMetadataCaching(beanName);
    }

    @Override
    public void preInstantiateSingletons() throws BeansException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Pre-instantiating singletons in " + this);
        }
        ArrayList<String> beanNames = new ArrayList<String>(this.beanDefinitionNames);
        for (String beanName : beanNames) {
            RootBeanDefinition bd = this.getMergedLocalBeanDefinition(beanName);
            if (bd.isAbstract() || !bd.isSingleton() || bd.isLazyInit()) continue;
            if (this.isFactoryBean(beanName)) {
                boolean isEagerInit;
                final FactoryBean factory = (FactoryBean)this.getBean("&" + beanName);
                if (System.getSecurityManager() != null && factory instanceof SmartFactoryBean) {
                    isEagerInit = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                        @Override
                        public Boolean run() {
                            return ((SmartFactoryBean)factory).isEagerInit();
                        }
                    }, this.getAccessControlContext());
                } else {
                    boolean bl = isEagerInit = factory instanceof SmartFactoryBean && ((SmartFactoryBean)factory).isEagerInit();
                }
                if (!isEagerInit) continue;
                this.getBean(beanName);
                continue;
            }
            this.getBean(beanName);
        }
        for (String beanName : beanNames) {
            Object singletonInstance = this.getSingleton(beanName);
            if (!(singletonInstance instanceof SmartInitializingSingleton)) continue;
            final SmartInitializingSingleton smartSingleton = (SmartInitializingSingleton)singletonInstance;
            if (System.getSecurityManager() != null) {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        smartSingleton.afterSingletonsInstantiated();
                        return null;
                    }
                }, this.getAccessControlContext());
                continue;
            }
            smartSingleton.afterSingletonsInstantiated();
        }
    }

    @Override
    public void registerBeanDefinition(String beanName, BeanDefinition beanDefinition) throws BeanDefinitionStoreException {
        BeanDefinition oldBeanDefinition;
        Assert.hasText(beanName, "Bean name must not be empty");
        Assert.notNull(beanDefinition, "BeanDefinition must not be null");
        if (beanDefinition instanceof AbstractBeanDefinition) {
            try {
                ((AbstractBeanDefinition)beanDefinition).validate();
            }
            catch (BeanDefinitionValidationException ex) {
                throw new BeanDefinitionStoreException(beanDefinition.getResourceDescription(), beanName, "Validation of bean definition failed", ex);
            }
        }
        if ((oldBeanDefinition = this.beanDefinitionMap.get(beanName)) != null) {
            if (!this.isAllowBeanDefinitionOverriding()) {
                throw new BeanDefinitionStoreException(beanDefinition.getResourceDescription(), beanName, "Cannot register bean definition [" + beanDefinition + "] for bean '" + beanName + "': There is already [" + oldBeanDefinition + "] bound.");
            }
            if (oldBeanDefinition.getRole() < beanDefinition.getRole()) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Overriding user-defined bean definition for bean '" + beanName + "' with a framework-generated bean definition: replacing [" + oldBeanDefinition + "] with [" + beanDefinition + "]");
                }
            } else if (!beanDefinition.equals(oldBeanDefinition)) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Overriding bean definition for bean '" + beanName + "' with a different definition: replacing [" + oldBeanDefinition + "] with [" + beanDefinition + "]");
                }
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("Overriding bean definition for bean '" + beanName + "' with an equivalent definition: replacing [" + oldBeanDefinition + "] with [" + beanDefinition + "]");
            }
        } else {
            this.beanDefinitionNames.add(beanName);
            this.manualSingletonNames.remove(beanName);
            this.frozenBeanDefinitionNames = null;
        }
        this.beanDefinitionMap.put(beanName, beanDefinition);
        if (oldBeanDefinition != null || this.containsSingleton(beanName)) {
            this.resetBeanDefinition(beanName);
        }
    }

    @Override
    public void removeBeanDefinition(String beanName) throws NoSuchBeanDefinitionException {
        Assert.hasText(beanName, "'beanName' must not be empty");
        BeanDefinition bd = this.beanDefinitionMap.remove(beanName);
        if (bd == null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("No bean named '" + beanName + "' found in " + this);
            }
            throw new NoSuchBeanDefinitionException(beanName);
        }
        this.beanDefinitionNames.remove(beanName);
        this.frozenBeanDefinitionNames = null;
        this.resetBeanDefinition(beanName);
    }

    protected void resetBeanDefinition(String beanName) {
        this.clearMergedBeanDefinition(beanName);
        this.destroySingleton(beanName);
        for (String bdName : this.beanDefinitionNames) {
            BeanDefinition bd;
            if (beanName.equals(bdName) || !beanName.equals((bd = this.beanDefinitionMap.get(bdName)).getParentName())) continue;
            this.resetBeanDefinition(bdName);
        }
    }

    @Override
    protected boolean allowAliasOverriding() {
        return this.isAllowBeanDefinitionOverriding();
    }

    @Override
    public void registerSingleton(String beanName, Object singletonObject) throws IllegalStateException {
        super.registerSingleton(beanName, singletonObject);
        if (!this.beanDefinitionMap.containsKey(beanName)) {
            this.manualSingletonNames.add(beanName);
        }
        this.clearByTypeCache();
    }

    @Override
    public void destroySingleton(String beanName) {
        super.destroySingleton(beanName);
        this.manualSingletonNames.remove(beanName);
        this.clearByTypeCache();
    }

    @Override
    public void destroySingletons() {
        super.destroySingletons();
        this.manualSingletonNames.clear();
        this.clearByTypeCache();
    }

    private void clearByTypeCache() {
        this.allBeanNamesByType.clear();
        this.singletonBeanNamesByType.clear();
    }

    @Override
    public Object resolveDependency(DependencyDescriptor descriptor2, String beanName, Set<String> autowiredBeanNames, TypeConverter typeConverter) throws BeansException {
        descriptor2.initParameterNameDiscovery(this.getParameterNameDiscoverer());
        if (descriptor2.getDependencyType().equals(javaUtilOptionalClass)) {
            return new OptionalDependencyFactory().createOptionalDependency(descriptor2, beanName);
        }
        if (ObjectFactory.class == descriptor2.getDependencyType()) {
            return new DependencyObjectFactory(descriptor2, beanName);
        }
        if (javaxInjectProviderClass == descriptor2.getDependencyType()) {
            return new DependencyProviderFactory().createDependencyProvider(descriptor2, beanName);
        }
        Object result = this.getAutowireCandidateResolver().getLazyResolutionProxyIfNecessary(descriptor2, beanName);
        if (result == null) {
            result = this.doResolveDependency(descriptor2, beanName, autowiredBeanNames, typeConverter);
        }
        return result;
    }

    public Object doResolveDependency(DependencyDescriptor descriptor2, String beanName, Set<String> autowiredBeanNames, TypeConverter typeConverter) throws BeansException {
        Class<?> type2 = descriptor2.getDependencyType();
        Object value = this.getAutowireCandidateResolver().getSuggestedValue(descriptor2);
        if (value != null) {
            if (value instanceof String) {
                String strVal = this.resolveEmbeddedValue((String)value);
                BeanDefinition bd = beanName != null && this.containsBean(beanName) ? this.getMergedBeanDefinition(beanName) : null;
                value = this.evaluateBeanDefinitionString(strVal, bd);
            }
            TypeConverter converter = typeConverter != null ? typeConverter : this.getTypeConverter();
            return descriptor2.getField() != null ? converter.convertIfNecessary(value, type2, descriptor2.getField()) : converter.convertIfNecessary(value, type2, descriptor2.getMethodParameter());
        }
        if (type2.isArray()) {
            Class<?> componentType = type2.getComponentType();
            DependencyDescriptor targetDesc = new DependencyDescriptor(descriptor2);
            targetDesc.increaseNestingLevel();
            Map<String, Object> matchingBeans = this.findAutowireCandidates(beanName, componentType, targetDesc);
            if (matchingBeans.isEmpty()) {
                if (descriptor2.isRequired()) {
                    this.raiseNoSuchBeanDefinitionException(componentType, "array of " + componentType.getName(), descriptor2);
                }
                return null;
            }
            if (autowiredBeanNames != null) {
                autowiredBeanNames.addAll(matchingBeans.keySet());
            }
            TypeConverter converter = typeConverter != null ? typeConverter : this.getTypeConverter();
            Object result = converter.convertIfNecessary(matchingBeans.values(), type2);
            if (this.getDependencyComparator() != null && result instanceof Object[]) {
                Arrays.sort((Object[])result, this.adaptDependencyComparator(matchingBeans));
            }
            return result;
        }
        if (Collection.class.isAssignableFrom(type2) && type2.isInterface()) {
            Class<?> elementType = descriptor2.getCollectionType();
            if (elementType == null) {
                if (descriptor2.isRequired()) {
                    throw new FatalBeanException("No element type declared for collection [" + type2.getName() + "]");
                }
                return null;
            }
            DependencyDescriptor targetDesc = new DependencyDescriptor(descriptor2);
            targetDesc.increaseNestingLevel();
            Map<String, Object> matchingBeans = this.findAutowireCandidates(beanName, elementType, targetDesc);
            if (matchingBeans.isEmpty()) {
                if (descriptor2.isRequired()) {
                    this.raiseNoSuchBeanDefinitionException(elementType, "collection of " + elementType.getName(), descriptor2);
                }
                return null;
            }
            if (autowiredBeanNames != null) {
                autowiredBeanNames.addAll(matchingBeans.keySet());
            }
            TypeConverter converter = typeConverter != null ? typeConverter : this.getTypeConverter();
            Object result = converter.convertIfNecessary(matchingBeans.values(), type2);
            if (this.getDependencyComparator() != null && result instanceof List) {
                Collections.sort((List)result, this.adaptDependencyComparator(matchingBeans));
            }
            return result;
        }
        if (Map.class.isAssignableFrom(type2) && type2.isInterface()) {
            Class<?> keyType = descriptor2.getMapKeyType();
            if (String.class != keyType) {
                if (descriptor2.isRequired()) {
                    throw new FatalBeanException("Key type [" + keyType + "] of map [" + type2.getName() + "] must be [java.lang.String]");
                }
                return null;
            }
            Class<?> valueType = descriptor2.getMapValueType();
            if (valueType == null) {
                if (descriptor2.isRequired()) {
                    throw new FatalBeanException("No value type declared for map [" + type2.getName() + "]");
                }
                return null;
            }
            DependencyDescriptor targetDesc = new DependencyDescriptor(descriptor2);
            targetDesc.increaseNestingLevel();
            Map<String, Object> matchingBeans = this.findAutowireCandidates(beanName, valueType, targetDesc);
            if (matchingBeans.isEmpty()) {
                if (descriptor2.isRequired()) {
                    this.raiseNoSuchBeanDefinitionException(valueType, "map with value type " + valueType.getName(), descriptor2);
                }
                return null;
            }
            if (autowiredBeanNames != null) {
                autowiredBeanNames.addAll(matchingBeans.keySet());
            }
            return matchingBeans;
        }
        Map<String, Object> matchingBeans = this.findAutowireCandidates(beanName, type2, descriptor2);
        if (matchingBeans.isEmpty()) {
            if (descriptor2.isRequired()) {
                this.raiseNoSuchBeanDefinitionException(type2, "", descriptor2);
            }
            return null;
        }
        if (matchingBeans.size() > 1) {
            String primaryBeanName = this.determineAutowireCandidate(matchingBeans, descriptor2);
            if (primaryBeanName == null) {
                throw new NoUniqueBeanDefinitionException(type2, matchingBeans.keySet());
            }
            if (autowiredBeanNames != null) {
                autowiredBeanNames.add(primaryBeanName);
            }
            return matchingBeans.get(primaryBeanName);
        }
        Map.Entry<String, Object> entry = matchingBeans.entrySet().iterator().next();
        if (autowiredBeanNames != null) {
            autowiredBeanNames.add(entry.getKey());
        }
        return entry.getValue();
    }

    private Comparator<Object> adaptDependencyComparator(Map<String, Object> matchingBeans) {
        Comparator<Object> comparator2 = this.getDependencyComparator();
        if (comparator2 instanceof OrderComparator) {
            return ((OrderComparator)comparator2).withSourceProvider(this.createFactoryAwareOrderSourceProvider(matchingBeans));
        }
        return comparator2;
    }

    private FactoryAwareOrderSourceProvider createFactoryAwareOrderSourceProvider(Map<String, Object> beans) {
        IdentityHashMap<Object, String> instancesToBeanNames = new IdentityHashMap<Object, String>();
        for (Map.Entry<String, Object> entry : beans.entrySet()) {
            instancesToBeanNames.put(entry.getValue(), entry.getKey());
        }
        return new FactoryAwareOrderSourceProvider(instancesToBeanNames);
    }

    protected Map<String, Object> findAutowireCandidates(String beanName, Class<?> requiredType, DependencyDescriptor descriptor2) {
        String[] candidateNames = BeanFactoryUtils.beanNamesForTypeIncludingAncestors(this, requiredType, true, descriptor2.isEager());
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(candidateNames.length);
        for (Class<?> autowiringType : this.resolvableDependencies.keySet()) {
            if (!autowiringType.isAssignableFrom(requiredType)) continue;
            Object autowiringValue = this.resolvableDependencies.get(autowiringType);
            if (!requiredType.isInstance(autowiringValue = AutowireUtils.resolveAutowiringValue(autowiringValue, requiredType))) continue;
            result.put(ObjectUtils.identityToString(autowiringValue), autowiringValue);
            break;
        }
        for (String candidateName : candidateNames) {
            if (this.isSelfReference(beanName, candidateName) || !this.isAutowireCandidate(candidateName, descriptor2)) continue;
            result.put(candidateName, this.getBean(candidateName));
        }
        if (result.isEmpty()) {
            DependencyDescriptor fallbackDescriptor = descriptor2.forFallbackMatch();
            for (String candidateName : candidateNames) {
                if (candidateName.equals(beanName) || !this.isAutowireCandidate(candidateName, fallbackDescriptor)) continue;
                result.put(candidateName, this.getBean(candidateName));
            }
        }
        return result;
    }

    protected String determineAutowireCandidate(Map<String, Object> candidateBeans, DependencyDescriptor descriptor2) {
        Class<?> requiredType = descriptor2.getDependencyType();
        String primaryCandidate = this.determinePrimaryCandidate(candidateBeans, requiredType);
        if (primaryCandidate != null) {
            return primaryCandidate;
        }
        String priorityCandidate = this.determineHighestPriorityCandidate(candidateBeans, requiredType);
        if (priorityCandidate != null) {
            return priorityCandidate;
        }
        for (Map.Entry<String, Object> entry : candidateBeans.entrySet()) {
            String candidateBeanName = entry.getKey();
            Object beanInstance = entry.getValue();
            if (!this.resolvableDependencies.values().contains(beanInstance) && !this.matchesBeanName(candidateBeanName, descriptor2.getDependencyName())) continue;
            return candidateBeanName;
        }
        return null;
    }

    protected String determinePrimaryCandidate(Map<String, Object> candidateBeans, Class<?> requiredType) {
        String primaryBeanName = null;
        for (Map.Entry<String, Object> entry : candidateBeans.entrySet()) {
            Object beanInstance;
            String candidateBeanName = entry.getKey();
            if (!this.isPrimary(candidateBeanName, beanInstance = entry.getValue())) continue;
            if (primaryBeanName != null) {
                boolean candidateLocal = this.containsBeanDefinition(candidateBeanName);
                boolean primaryLocal = this.containsBeanDefinition(primaryBeanName);
                if (candidateLocal && primaryLocal) {
                    throw new NoUniqueBeanDefinitionException(requiredType, candidateBeans.size(), "more than one 'primary' bean found among candidates: " + candidateBeans.keySet());
                }
                if (!candidateLocal) continue;
                primaryBeanName = candidateBeanName;
                continue;
            }
            primaryBeanName = candidateBeanName;
        }
        return primaryBeanName;
    }

    protected String determineHighestPriorityCandidate(Map<String, Object> candidateBeans, Class<?> requiredType) {
        String highestPriorityBeanName = null;
        Integer highestPriority = null;
        for (Map.Entry<String, Object> entry : candidateBeans.entrySet()) {
            String candidateBeanName = entry.getKey();
            Object beanInstance = entry.getValue();
            Integer candidatePriority = this.getPriority(beanInstance);
            if (candidatePriority == null) continue;
            if (highestPriorityBeanName != null) {
                if (candidatePriority.equals(highestPriority)) {
                    throw new NoUniqueBeanDefinitionException(requiredType, candidateBeans.size(), "Multiple beans found with the same priority ('" + highestPriority + "') " + "among candidates: " + candidateBeans.keySet());
                }
                if (candidatePriority >= highestPriority) continue;
                highestPriorityBeanName = candidateBeanName;
                highestPriority = candidatePriority;
                continue;
            }
            highestPriorityBeanName = candidateBeanName;
            highestPriority = candidatePriority;
        }
        return highestPriorityBeanName;
    }

    protected boolean isPrimary(String beanName, Object beanInstance) {
        if (this.containsBeanDefinition(beanName)) {
            return this.getMergedLocalBeanDefinition(beanName).isPrimary();
        }
        BeanFactory parentFactory = this.getParentBeanFactory();
        return parentFactory instanceof DefaultListableBeanFactory && ((DefaultListableBeanFactory)parentFactory).isPrimary(beanName, beanInstance);
    }

    protected Integer getPriority(Object beanInstance) {
        Comparator<Object> comparator2 = this.getDependencyComparator();
        if (comparator2 instanceof OrderComparator) {
            return ((OrderComparator)comparator2).getPriority(beanInstance);
        }
        return null;
    }

    protected boolean matchesBeanName(String beanName, String candidateName) {
        return candidateName != null && (candidateName.equals(beanName) || ObjectUtils.containsElement(this.getAliases(beanName), candidateName));
    }

    private boolean isSelfReference(String beanName, String candidateName) {
        return beanName != null && candidateName != null && (beanName.equals(candidateName) || this.containsBeanDefinition(candidateName) && beanName.equals(this.getMergedLocalBeanDefinition(candidateName).getFactoryBeanName()));
    }

    private void raiseNoSuchBeanDefinitionException(Class<?> type2, String dependencyDescription, DependencyDescriptor descriptor2) throws NoSuchBeanDefinitionException {
        throw new NoSuchBeanDefinitionException(type2, dependencyDescription, "expected at least 1 bean which qualifies as autowire candidate for this dependency. Dependency annotations: " + ObjectUtils.nullSafeToString(descriptor2.getAnnotations()));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(ObjectUtils.identityToString(this));
        sb.append(": defining beans [");
        sb.append(StringUtils.collectionToCommaDelimitedString(this.beanDefinitionNames));
        sb.append("]; ");
        BeanFactory parent = this.getParentBeanFactory();
        if (parent == null) {
            sb.append("root of factory hierarchy");
        } else {
            sb.append("parent: ").append(ObjectUtils.identityToString(parent));
        }
        return sb.toString();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        throw new NotSerializableException("DefaultListableBeanFactory itself is not deserializable - just a SerializedBeanFactoryReference is");
    }

    protected Object writeReplace() throws ObjectStreamException {
        if (this.serializationId != null) {
            return new SerializedBeanFactoryReference(this.serializationId);
        }
        throw new NotSerializableException("DefaultListableBeanFactory has no serialization id");
    }

    static {
        try {
            javaUtilOptionalClass = ClassUtils.forName("java.util.Optional", DefaultListableBeanFactory.class.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            javaxInjectProviderClass = ClassUtils.forName("javax.inject.Provider", DefaultListableBeanFactory.class.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        serializableFactories = new ConcurrentHashMap<String, Reference<DefaultListableBeanFactory>>(8);
    }

    private class FactoryAwareOrderSourceProvider
    implements OrderComparator.OrderSourceProvider {
        private final Map<Object, String> instancesToBeanNames;

        public FactoryAwareOrderSourceProvider(Map<Object, String> instancesToBeanNames) {
            this.instancesToBeanNames = instancesToBeanNames;
        }

        @Override
        public Object getOrderSource(Object obj) {
            Class<?> targetType;
            RootBeanDefinition beanDefinition = this.getRootBeanDefinition(this.instancesToBeanNames.get(obj));
            if (beanDefinition == null) {
                return null;
            }
            ArrayList<GenericDeclaration> sources = new ArrayList<GenericDeclaration>();
            Method factoryMethod = beanDefinition.getResolvedFactoryMethod();
            if (factoryMethod != null) {
                sources.add(factoryMethod);
            }
            if ((targetType = beanDefinition.getTargetType()) != null && !targetType.equals(obj.getClass())) {
                sources.add(targetType);
            }
            return sources.toArray(new Object[sources.size()]);
        }

        private RootBeanDefinition getRootBeanDefinition(String beanName) {
            BeanDefinition bd;
            if (beanName != null && DefaultListableBeanFactory.this.containsBeanDefinition(beanName) && (bd = DefaultListableBeanFactory.this.getMergedBeanDefinition(beanName)) instanceof RootBeanDefinition) {
                return (RootBeanDefinition)bd;
            }
            return null;
        }
    }

    private class DependencyProviderFactory {
        private DependencyProviderFactory() {
        }

        public Object createDependencyProvider(DependencyDescriptor descriptor2, String beanName) {
            return new DependencyProvider(descriptor2, beanName);
        }
    }

    private class DependencyProvider
    extends DependencyObjectFactory
    implements Provider<Object> {
        public DependencyProvider(DependencyDescriptor descriptor2, String beanName) {
            super(descriptor2, beanName);
        }

        @Override
        public Object get() throws BeansException {
            return this.getObject();
        }
    }

    private class DependencyObjectFactory
    implements ObjectFactory<Object>,
    Serializable {
        private final DependencyDescriptor descriptor;
        private final boolean optional;
        private final String beanName;

        public DependencyObjectFactory(DependencyDescriptor descriptor2, String beanName) {
            this.descriptor = new DependencyDescriptor(descriptor2);
            this.descriptor.increaseNestingLevel();
            this.optional = this.descriptor.getDependencyType().equals(javaUtilOptionalClass);
            this.beanName = beanName;
        }

        @Override
        public Object getObject() throws BeansException {
            if (this.optional) {
                return new OptionalDependencyFactory().createOptionalDependency(this.descriptor, this.beanName);
            }
            return DefaultListableBeanFactory.this.doResolveDependency(this.descriptor, this.beanName, null, null);
        }
    }

    @UsesJava8
    private class OptionalDependencyFactory {
        private OptionalDependencyFactory() {
        }

        public Object createOptionalDependency(DependencyDescriptor descriptor2, String beanName) {
            DependencyDescriptor descriptorToUse = new DependencyDescriptor(descriptor2){

                @Override
                public boolean isRequired() {
                    return false;
                }
            };
            descriptorToUse.increaseNestingLevel();
            return Optional.ofNullable(DefaultListableBeanFactory.this.doResolveDependency(descriptorToUse, beanName, null, null));
        }
    }

    private static class SerializedBeanFactoryReference
    implements Serializable {
        private final String id;

        public SerializedBeanFactoryReference(String id) {
            this.id = id;
        }

        private Object readResolve() {
            Reference ref2 = (Reference)serializableFactories.get(this.id);
            if (ref2 == null) {
                throw new IllegalStateException("Cannot deserialize BeanFactory with id " + this.id + ": no factory registered for this id");
            }
            Object result = ref2.get();
            if (result == null) {
                throw new IllegalStateException("Cannot deserialize BeanFactory with id " + this.id + ": factory has been garbage-collected");
            }
            return result;
        }
    }
}

