/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.interceptor;

import com.jamonapi.MonKey;
import com.jamonapi.MonKeyImp;
import com.jamonapi.Monitor;
import com.jamonapi.MonitorFactory;
import com.jamonapi.utils.Misc;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.springframework.aop.interceptor.AbstractMonitoringInterceptor;

public class JamonPerformanceMonitorInterceptor
extends AbstractMonitoringInterceptor {
    private boolean trackAllInvocations = false;

    public JamonPerformanceMonitorInterceptor() {
    }

    public JamonPerformanceMonitorInterceptor(boolean useDynamicLogger) {
        this.setUseDynamicLogger(useDynamicLogger);
    }

    public JamonPerformanceMonitorInterceptor(boolean useDynamicLogger, boolean trackAllInvocations) {
        this.setUseDynamicLogger(useDynamicLogger);
        this.setTrackAllInvocations(trackAllInvocations);
    }

    public void setTrackAllInvocations(boolean trackAllInvocations) {
        this.trackAllInvocations = trackAllInvocations;
    }

    @Override
    protected boolean isInterceptorEnabled(MethodInvocation invocation, Log logger2) {
        return this.trackAllInvocations || this.isLogEnabled(logger2);
    }

    @Override
    protected Object invokeUnderTrace(MethodInvocation invocation, Log logger2) throws Throwable {
        String name2 = this.createInvocationTraceName(invocation);
        MonKeyImp key2 = new MonKeyImp(name2, (Object)name2, "ms.");
        Monitor monitor = MonitorFactory.start((MonKey)key2);
        try {
            Object object = invocation.proceed();
            return object;
        }
        catch (Throwable ex) {
            this.trackException((MonKey)key2, ex);
            throw ex;
        }
        finally {
            monitor.stop();
            if (!this.trackAllInvocations || this.isLogEnabled(logger2)) {
                logger2.trace("JAMon performance statistics for method [" + name2 + "]:\n" + monitor);
            }
        }
    }

    protected void trackException(MonKey key2, Throwable ex) {
        String stackTrace = "stackTrace=" + Misc.getExceptionTrace((Throwable)ex);
        key2.setDetails((Object)stackTrace);
        MonitorFactory.add((MonKey)new MonKeyImp(ex.getClass().getName(), (Object)stackTrace, "Exception"), (double)1.0);
        MonitorFactory.add((MonKey)new MonKeyImp("com.jamonapi.Exceptions", (Object)stackTrace, "Exception"), (double)1.0);
    }
}

