/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.aspectj.annotation;

import org.springframework.aop.aspectj.annotation.AspectMetadata;
import org.springframework.aop.aspectj.annotation.MetadataAwareAspectInstanceFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.OrderUtils;
import org.springframework.util.ClassUtils;

public class BeanFactoryAspectInstanceFactory
implements MetadataAwareAspectInstanceFactory {
    private final BeanFactory beanFactory;
    private final String name;
    private final AspectMetadata aspectMetadata;

    public BeanFactoryAspectInstanceFactory(BeanFactory beanFactory, String name2) {
        this(beanFactory, name2, beanFactory.getType(name2));
    }

    public BeanFactoryAspectInstanceFactory(BeanFactory beanFactory, String name2, Class<?> type2) {
        this.beanFactory = beanFactory;
        this.name = name2;
        this.aspectMetadata = new AspectMetadata(type2, name2);
    }

    @Override
    public Object getAspectInstance() {
        return this.beanFactory.getBean(this.name);
    }

    @Override
    public ClassLoader getAspectClassLoader() {
        if (this.beanFactory instanceof ConfigurableBeanFactory) {
            return ((ConfigurableBeanFactory)this.beanFactory).getBeanClassLoader();
        }
        return ClassUtils.getDefaultClassLoader();
    }

    @Override
    public AspectMetadata getAspectMetadata() {
        return this.aspectMetadata;
    }

    @Override
    public int getOrder() {
        Class<?> type2 = this.beanFactory.getType(this.name);
        if (type2 != null) {
            if (Ordered.class.isAssignableFrom(type2) && this.beanFactory.isSingleton(this.name)) {
                return ((Ordered)this.beanFactory.getBean(this.name)).getOrder();
            }
            return OrderUtils.getOrder(type2, Integer.MAX_VALUE);
        }
        return Integer.MAX_VALUE;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": bean name '" + this.name + "'";
    }
}

