/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.vfs;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarFile;
import javax.annotation.Nullable;
import org.reflections.Reflections;
import org.reflections.ReflectionsException;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.Utils;
import org.reflections.vfs.JarInputDir;
import org.reflections.vfs.SystemDir;
import org.reflections.vfs.UrlTypeVFS;
import org.reflections.vfs.ZipDir;

public abstract class Vfs {
    private static List<UrlType> defaultUrlTypes = Lists.newArrayList(DefaultUrlTypes.values());

    public static List<UrlType> getDefaultUrlTypes() {
        return defaultUrlTypes;
    }

    public static void setDefaultURLTypes(List<UrlType> urlTypes) {
        defaultUrlTypes = urlTypes;
    }

    public static void addDefaultURLTypes(UrlType urlType) {
        defaultUrlTypes.add(0, urlType);
    }

    public static Dir fromURL(URL url) {
        return Vfs.fromURL(url, defaultUrlTypes);
    }

    public static Dir fromURL(URL url, List<UrlType> urlTypes) {
        for (UrlType type2 : urlTypes) {
            try {
                Dir dir2;
                if (!type2.matches(url) || (dir2 = type2.createDir(url)) == null) continue;
                return dir2;
            }
            catch (Throwable e2) {
                if (Reflections.log == null) continue;
                Reflections.log.warn("could not create Dir using " + type2 + " from url " + url.toExternalForm() + ". skipping.", e2);
            }
        }
        throw new ReflectionsException("could not create Vfs.Dir from url, no matching UrlType was found [" + url.toExternalForm() + "]\neither use fromURL(final URL url, final List<UrlType> urlTypes) or use the static setDefaultURLTypes(final List<UrlType> urlTypes) or addDefaultURLTypes(UrlType urlType) with your specialized UrlType.");
    }

    public static Dir fromURL(URL url, UrlType ... urlTypes) {
        return Vfs.fromURL(url, Lists.newArrayList(urlTypes));
    }

    public static Iterable<File> findFiles(Collection<URL> inUrls, final String packagePrefix, final Predicate<String> nameFilter) {
        Predicate<File> fileNamePredicate = new Predicate<File>(){

            @Override
            public boolean apply(File file2) {
                String path2 = file2.getRelativePath();
                if (path2.startsWith(packagePrefix)) {
                    String filename = path2.substring(path2.indexOf(packagePrefix) + packagePrefix.length());
                    return !Utils.isEmpty(filename) && nameFilter.apply(filename.substring(1));
                }
                return false;
            }
        };
        return Vfs.findFiles(inUrls, fileNamePredicate);
    }

    public static Iterable<File> findFiles(Collection<URL> inUrls, Predicate<File> filePredicate) {
        Iterable<File> result = new ArrayList<File>();
        for (final URL url : inUrls) {
            try {
                result = Iterables.concat(result, Iterables.filter(new Iterable<File>(){

                    @Override
                    public Iterator<File> iterator() {
                        return Vfs.fromURL(url).getFiles().iterator();
                    }
                }, filePredicate));
            }
            catch (Throwable e2) {
                if (Reflections.log == null) continue;
                Reflections.log.error("could not findFiles for url. continuing. [" + url + "]", e2);
            }
        }
        return result;
    }

    @Nullable
    public static java.io.File getFile(URL url) {
        java.io.File file2;
        String path2;
        try {
            path2 = url.toURI().getSchemeSpecificPart();
            file2 = new java.io.File(path2);
            if (file2.exists()) {
                return file2;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        try {
            path2 = URLDecoder.decode(url.getPath(), "UTF-8");
            if (path2.contains(".jar!")) {
                path2 = path2.substring(0, path2.lastIndexOf(".jar!") + ".jar".length());
            }
            if ((file2 = new java.io.File(path2)).exists()) {
                return file2;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        try {
            path2 = url.toExternalForm();
            if (path2.startsWith("jar:")) {
                path2 = path2.substring("jar:".length());
            }
            if (path2.startsWith("wsjar:")) {
                path2 = path2.substring("wsjar:".length());
            }
            if (path2.startsWith("file:")) {
                path2 = path2.substring("file:".length());
            }
            if (path2.contains(".jar!")) {
                path2 = path2.substring(0, path2.indexOf(".jar!") + ".jar".length());
            }
            if ((file2 = new java.io.File(path2)).exists()) {
                return file2;
            }
            file2 = new java.io.File(path2 = path2.replace("%20", " "));
            if (file2.exists()) {
                return file2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static boolean hasJarFileInPath(URL url) {
        return url.toExternalForm().matches(".*\\.jar(\\!.*|$)");
    }

    public static enum DefaultUrlTypes implements UrlType
    {
        jarFile{

            @Override
            public boolean matches(URL url) {
                return url.getProtocol().equals("file") && Vfs.hasJarFileInPath(url);
            }

            @Override
            public Dir createDir(URL url) throws Exception {
                return new ZipDir(new JarFile(Vfs.getFile(url)));
            }
        }
        ,
        jarUrl{

            @Override
            public boolean matches(URL url) {
                return "jar".equals(url.getProtocol()) || "zip".equals(url.getProtocol()) || "wsjar".equals(url.getProtocol());
            }

            @Override
            public Dir createDir(URL url) throws Exception {
                try {
                    URLConnection urlConnection = url.openConnection();
                    if (urlConnection instanceof JarURLConnection) {
                        return new ZipDir(((JarURLConnection)urlConnection).getJarFile());
                    }
                }
                catch (Throwable urlConnection) {
                    // empty catch block
                }
                java.io.File file2 = Vfs.getFile(url);
                if (file2 != null) {
                    return new ZipDir(new JarFile(file2));
                }
                return null;
            }
        }
        ,
        directory{

            @Override
            public boolean matches(URL url) {
                if (url.getProtocol().equals("file") && !Vfs.hasJarFileInPath(url)) {
                    java.io.File file2 = Vfs.getFile(url);
                    return file2 != null && file2.isDirectory();
                }
                return false;
            }

            @Override
            public Dir createDir(URL url) throws Exception {
                return new SystemDir(Vfs.getFile(url));
            }
        }
        ,
        jboss_vfs{

            @Override
            public boolean matches(URL url) {
                return url.getProtocol().equals("vfs");
            }

            @Override
            public Dir createDir(URL url) throws Exception {
                Object content = url.openConnection().getContent();
                Class<?> virtualFile = ClasspathHelper.contextClassLoader().loadClass("org.jboss.vfs.VirtualFile");
                java.io.File physicalFile = (java.io.File)virtualFile.getMethod("getPhysicalFile", new Class[0]).invoke(content, new Object[0]);
                String name2 = (String)virtualFile.getMethod("getName", new Class[0]).invoke(content, new Object[0]);
                java.io.File file2 = new java.io.File(physicalFile.getParentFile(), name2);
                if (!file2.exists() || !file2.canRead()) {
                    file2 = physicalFile;
                }
                return file2.isDirectory() ? new SystemDir(file2) : new ZipDir(new JarFile(file2));
            }
        }
        ,
        jboss_vfsfile{

            @Override
            public boolean matches(URL url) throws Exception {
                return "vfszip".equals(url.getProtocol()) || "vfsfile".equals(url.getProtocol());
            }

            @Override
            public Dir createDir(URL url) throws Exception {
                return new UrlTypeVFS().createDir(url);
            }
        }
        ,
        bundle{

            @Override
            public boolean matches(URL url) throws Exception {
                return url.getProtocol().startsWith("bundle");
            }

            @Override
            public Dir createDir(URL url) throws Exception {
                return Vfs.fromURL((URL)ClasspathHelper.contextClassLoader().loadClass("org.eclipse.core.runtime.FileLocator").getMethod("resolve", URL.class).invoke(null, url));
            }
        }
        ,
        jarInputStream{

            @Override
            public boolean matches(URL url) throws Exception {
                return url.toExternalForm().contains(".jar");
            }

            @Override
            public Dir createDir(URL url) throws Exception {
                return new JarInputDir(url);
            }
        };

    }

    public static interface UrlType {
        public boolean matches(URL var1) throws Exception;

        public Dir createDir(URL var1) throws Exception;
    }

    public static interface File {
        public String getName();

        public String getRelativePath();

        public InputStream openInputStream() throws IOException;
    }

    public static interface Dir {
        public String getPath();

        public Iterable<File> getFiles();

        public void close();
    }
}

