/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.reflection.instantiation;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.logging.messages.ReflectionMessage;
import org.jboss.weld.util.reflection.SecureReflections;
import org.jboss.weld.util.reflection.instantiation.Instantiator;

public class UnsafeInstantiator
implements Instantiator {
    private static final String REFLECTION_CLASS_NAME = "sun.misc.Unsafe";
    private Method allocateInstanceMethod = null;
    private Object unsafeInstance = null;

    private void init() {
        try {
            Class<?> unsafe = Class.forName(REFLECTION_CLASS_NAME);
            Field accessor2 = unsafe.getDeclaredField("theUnsafe");
            SecureReflections.ensureAccessible(accessor2);
            this.unsafeInstance = accessor2.get(null);
            this.allocateInstanceMethod = unsafe.getDeclaredMethod("allocateInstance", Class.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean isAvailable() {
        this.init();
        return this.allocateInstanceMethod != null && this.unsafeInstance != null;
    }

    @Override
    public <T> T instantiate(Class<T> clazz) {
        try {
            return (T)this.allocateInstanceMethod.invoke(this.unsafeInstance, clazz);
        }
        catch (Exception e2) {
            throw new WeldException(ReflectionMessage.UNSAFE_INSTANTIATION_FAILED, (Throwable)e2, clazz);
        }
    }
}

