/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.cache;

import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.concurrent.ExecutionException;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.logging.messages.UtilMessage;

public final class LoadingCacheUtils {
    private LoadingCacheUtils() {
    }

    public static <K, V> V getCacheValue(LoadingCache<K, V> cache, K key2) {
        try {
            return cache.get(key2);
        }
        catch (ExecutionException e2) {
            throw new WeldException(UtilMessage.UNABLE_TO_LOAD_CACHE_VALUE, e2.getCause(), key2);
        }
        catch (UncheckedExecutionException e3) {
            Throwable cause = e3.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new WeldException(UtilMessage.UNABLE_TO_LOAD_CACHE_VALUE, cause, key2);
        }
    }

    public static <T, K, V> T getCastCacheValue(LoadingCache<K, V> cache, Object key2) {
        return (T)LoadingCacheUtils.getCacheValue(cache, key2);
    }
}

