/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.bytecode;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import javassist.CannotCompileException;
import javassist.bytecode.ClassFile;

public class ClassFileUtils {
    private static Method defineClass1;
    private static Method defineClass2;

    public static Class<?> toClass(ClassFile ct, ClassLoader loader, ProtectionDomain domain) throws CannotCompileException {
        try {
            Object[] args;
            Method method;
            byte[] b = ClassFileUtils.toBytecode(ct);
            if (domain == null) {
                method = defineClass1;
                args = new Object[]{ct.getName(), b, new Integer(0), new Integer(b.length)};
            } else {
                method = defineClass2;
                args = new Object[]{ct.getName(), b, new Integer(0), new Integer(b.length), domain};
            }
            return ClassFileUtils.toClass2(method, loader, args);
        }
        catch (RuntimeException e2) {
            throw e2;
        }
        catch (InvocationTargetException e3) {
            throw new CannotCompileException(e3.getTargetException());
        }
        catch (Exception e4) {
            throw new CannotCompileException(e4);
        }
    }

    public static byte[] toBytecode(ClassFile file2) {
        try {
            ByteArrayOutputStream bytes2 = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(bytes2);
            file2.write(out);
            return bytes2.toByteArray();
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    private static synchronized Class<?> toClass2(Method method, ClassLoader loader, Object[] args) throws Exception {
        method.setAccessible(true);
        Class clazz = (Class)Class.class.cast(method.invoke((Object)loader, args));
        method.setAccessible(false);
        return clazz;
    }

    static {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    Class<?> cl = Class.forName("java.lang.ClassLoader");
                    defineClass1 = cl.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
                    defineClass2 = cl.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new RuntimeException("cannot initialize ClassPool", pae.getException());
        }
    }
}

