/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.metadata.FileMetadata;

public class ServiceLoader<S>
implements Iterable<Metadata<S>> {
    private static final String SERVICES = "META-INF/services";
    private static final Logger log = Logger.getLogger("ServiceLoader");
    private final String serviceFile;
    private Class<S> expectedType;
    private final ClassLoader loader;
    private Set<Metadata<S>> providers;

    public static <S> ServiceLoader<S> load(Class<S> service) {
        return ServiceLoader.load(service, Thread.currentThread().getContextClassLoader());
    }

    public static <S> ServiceLoader<S> load(Class<S> service, ClassLoader loader) {
        if (loader == null) {
            loader = service.getClassLoader();
        }
        return new ServiceLoader<S>(service, loader);
    }

    public static <S> ServiceLoader<S> loadInstalled(Class<S> service) {
        throw new UnsupportedOperationException("Not implemented");
    }

    private ServiceLoader(Class<S> service, ClassLoader loader) {
        this.loader = loader;
        this.serviceFile = "META-INF/services/" + service.getName();
        this.expectedType = service;
    }

    public void reload() {
        this.providers = new HashSet<Metadata<S>>();
        for (URL serviceFile : this.loadServiceFiles()) {
            this.loadServiceFile(serviceFile);
        }
    }

    private List<URL> loadServiceFiles() {
        ArrayList<URL> serviceFiles = new ArrayList<URL>();
        try {
            Enumeration<URL> serviceFileEnumerator = this.loader.getResources(this.serviceFile);
            while (serviceFileEnumerator.hasMoreElements()) {
                serviceFiles.add(serviceFileEnumerator.nextElement());
            }
        }
        catch (IOException e2) {
            throw new RuntimeException("Could not load resources from " + this.serviceFile, e2);
        }
        return serviceFiles;
    }

    private void loadServiceFile(URL serviceFile) {
        InputStream is2 = null;
        try {
            is2 = serviceFile.openStream();
            BufferedReader reader2 = new BufferedReader(new InputStreamReader(is2, "UTF-8"));
            String serviceClassName = null;
            int i = 0;
            while ((serviceClassName = reader2.readLine()) != null) {
                ++i;
                if ((serviceClassName = this.trim(serviceClassName)).length() <= 0) continue;
                this.loadService(serviceClassName, serviceFile, i);
            }
        }
        catch (IOException e2) {
            throw new RuntimeException("Could not read services file " + serviceFile);
        }
        finally {
            if (is2 != null) {
                try {
                    is2.close();
                }
                catch (IOException e3) {
                    throw new RuntimeException("Could not close services file " + serviceFile, e3);
                }
            }
        }
    }

    private String trim(String line) {
        int comment2 = line.indexOf(35);
        if (comment2 > -1) {
            line = line.substring(0, comment2);
        }
        return line.trim();
    }

    private void loadService(String serviceClassName, URL file2, int lineNumber) {
        Class<S> serviceClass = this.loadClass(serviceClassName);
        if (serviceClass == null) {
            return;
        }
        S serviceInstance = this.prepareInstance(serviceClass);
        if (serviceInstance == null) {
            return;
        }
        this.providers.add(new FileMetadata<S>(serviceInstance, file2, lineNumber));
    }

    private Class<? extends S> loadClass(String serviceClassName) {
        Class<?> clazz = null;
        Class<S> serviceClass = null;
        try {
            clazz = this.loader.loadClass(serviceClassName);
            serviceClass = clazz.asSubclass(this.expectedType);
        }
        catch (ClassNotFoundException e2) {
            log.warning("Could not load service class " + serviceClassName);
        }
        catch (ClassCastException e3) {
            throw new RuntimeException("Service class " + serviceClassName + " didn't implement the Extension interface");
        }
        return serviceClass;
    }

    private S prepareInstance(Class<? extends S> serviceClass) {
        try {
            Constructor<S> constructor = serviceClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (LinkageError e2) {
            log.log(Level.WARNING, "Could not instantiate service class " + serviceClass.getName(), e2);
            return null;
        }
        catch (InvocationTargetException e3) {
            throw new RuntimeException("Error instantiating " + serviceClass, e3.getCause());
        }
        catch (IllegalArgumentException e4) {
            throw new RuntimeException("Error instantiating " + serviceClass, e4);
        }
        catch (InstantiationException e5) {
            throw new RuntimeException("Error instantiating " + serviceClass, e5);
        }
        catch (IllegalAccessException e6) {
            throw new RuntimeException("Error instantiating " + serviceClass, e6);
        }
        catch (SecurityException e7) {
            throw new RuntimeException("Error instantiating " + serviceClass, e7);
        }
        catch (NoSuchMethodException e8) {
            throw new RuntimeException("Error instantiating " + serviceClass, e8);
        }
    }

    @Override
    public Iterator<Metadata<S>> iterator() {
        if (this.providers == null) {
            this.reload();
        }
        return this.providers.iterator();
    }

    public String toString() {
        return "Services for " + this.serviceFile;
    }
}

