/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resolution;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resolution.Resolvable;
import org.jboss.weld.util.cache.LoadingCacheUtils;

public abstract class TypeSafeResolver<R extends Resolvable, T> {
    private static final long RESOLVED_CACHE_UPPER_BOUND = Long.getLong("org.jboss.weld.resolution.cacheSize", 0x100000L);
    private static final long DEFAULT_RESOLVED_CACHE_UPPER_BOUND = 0x100000L;
    private final LoadingCache<R, Set<T>> resolved;
    private final Iterable<? extends T> allBeans;
    private final ResolvableToBeanSet<R, T> resolverFunction;
    private final BeanManagerImpl beanManager;

    public TypeSafeResolver(Iterable<? extends T> allBeans, BeanManagerImpl beanManager) {
        this.beanManager = beanManager;
        this.resolverFunction = new ResolvableToBeanSet(this);
        this.resolved = CacheBuilder.newBuilder().maximumSize(RESOLVED_CACHE_UPPER_BOUND).build(this.resolverFunction);
        this.allBeans = allBeans;
    }

    public void clear() {
        this.resolved.invalidateAll();
    }

    public Set<T> resolve(R resolvable, boolean cache) {
        R wrappedResolvable = this.wrap(resolvable);
        if (cache) {
            return LoadingCacheUtils.getCacheValue(this.resolved, wrappedResolvable);
        }
        return this.resolverFunction.load(wrappedResolvable);
    }

    private Set<T> findMatching(R resolvable) {
        HashSet<T> result = new HashSet<T>();
        for (T bean2 : this.getAllBeans(resolvable)) {
            if (!this.matches(resolvable, bean2)) continue;
            result.add(bean2);
        }
        HashSet<T> iterable = result;
        return ImmutableSet.copyOf(iterable);
    }

    protected Iterable<? extends T> getAllBeans(R resolvable) {
        return this.allBeans;
    }

    protected Iterable<? extends T> getAllBeans() {
        return this.allBeans;
    }

    protected abstract Set<T> filterResult(Set<T> var1);

    protected abstract Set<T> sortResult(Set<T> var1);

    protected abstract boolean matches(R var1, T var2);

    protected R wrap(R resolvable) {
        return resolvable;
    }

    public boolean isCached(R resolvable) {
        return this.resolved.getIfPresent(this.wrap(resolvable)) != null;
    }

    protected BeanManagerImpl getBeanManager() {
        return this.beanManager;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Resolver\n");
        buffer.append("Resolved injection points: " + this.resolved.size() + "\n");
        return buffer.toString();
    }

    private static class ResolvableToBeanSet<R extends Resolvable, T>
    extends CacheLoader<R, Set<T>> {
        private final TypeSafeResolver<R, T> resolver;

        private ResolvableToBeanSet(TypeSafeResolver<R, T> resolver) {
            this.resolver = resolver;
        }

        @Override
        public Set<T> load(R from) {
            return this.resolver.sortResult(this.resolver.filterResult(((TypeSafeResolver)this.resolver).findMatching(from)));
        }
    }
}

