/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resolution;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Primitives;
import java.io.Serializable;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.Bean;
import javax.inject.Provider;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resolution.QualifierInstance;
import org.jboss.weld.resolution.Resolvable;
import org.jboss.weld.resolution.TypeSafeResolver;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.LazyValueHolder;
import org.jboss.weld.util.cache.LoadingCacheUtils;
import org.jboss.weld.util.reflection.Reflections;

public class TypeSafeBeanResolver<T extends Bean<?>>
extends TypeSafeResolver<Resolvable, T> {
    private final BeanManagerImpl beanManager;
    private final LoadingCache<Set<Bean<?>>, Set<Bean<?>>> disambiguatedBeans;
    private final LazyValueHolder<Map<Type, ArrayList<T>>> beansByType;

    public TypeSafeBeanResolver(BeanManagerImpl beanManager, final Iterable<T> beans) {
        super(beans, beanManager);
        this.beanManager = beanManager;
        this.disambiguatedBeans = CacheBuilder.newBuilder().build(new BeanDisambiguation());
        this.beansByType = new LazyValueHolder<Map<Type, ArrayList<T>>>(){

            @Override
            protected Map<Type, ArrayList<T>> computeValue() {
                HashMap map2 = new HashMap();
                for (Bean bean2 : beans) {
                    this.mapBean(map2, bean2);
                }
                this.trimArrayListsToSize(map2);
                return Collections.unmodifiableMap(map2);
            }

            private void mapBean(Map<Type, ArrayList<T>> map2, T bean2) {
                for (Type type2 : bean2.getTypes()) {
                    Class clazz;
                    this.mapTypeToBean(map2, type2, bean2);
                    if (type2 instanceof ParameterizedType) {
                        Type rawType = ((ParameterizedType)type2).getRawType();
                        this.mapTypeToBean(map2, rawType, bean2);
                        continue;
                    }
                    if (!(type2 instanceof Class) || !(clazz = (Class)type2).isPrimitive()) continue;
                    Class wrapped = Primitives.wrap(clazz);
                    this.mapTypeToBean(map2, wrapped, bean2);
                }
            }

            private void mapTypeToBean(Map<Type, ArrayList<T>> map2, Type type2, T bean2) {
                if (!map2.containsKey(type2)) {
                    map2.put(type2, new ArrayList());
                }
                map2.get(type2).add(bean2);
            }

            private void trimArrayListsToSize(Map<Type, ArrayList<T>> map2) {
                for (Map.Entry entry : map2.entrySet()) {
                    entry.getValue().trimToSize();
                }
            }
        };
    }

    @Override
    protected boolean matches(Resolvable resolvable, T bean2) {
        return Reflections.matches(resolvable.getTypes(), bean2.getTypes()) && Beans.containsAllQualifiers(resolvable.getQualifiers(), QualifierInstance.qualifiers(this.beanManager, bean2), this.beanManager);
    }

    @Override
    protected Iterable<? extends T> getAllBeans(Resolvable resolvable) {
        if (resolvable.getTypes().contains(Object.class) || Instance.class.equals(resolvable.getJavaClass()) || Event.class.equals(resolvable.getJavaClass()) || Provider.class.equals(resolvable.getJavaClass()) || resolvable.getTypes().contains(Serializable.class)) {
            return super.getAllBeans(resolvable);
        }
        HashSet<T> beans = new HashSet<T>();
        for (Type type2 : resolvable.getTypes()) {
            beans.addAll(this.getBeans(type2));
            if (type2 instanceof ParameterizedType) {
                Type rawType = ((ParameterizedType)type2).getRawType();
                beans.addAll(this.getBeans(rawType));
                continue;
            }
            if (type2 instanceof Class) {
                Class clazz = (Class)type2;
                if (!clazz.isPrimitive()) continue;
                clazz = Primitives.wrap(clazz);
                beans.addAll(this.getBeans(clazz));
                continue;
            }
            if (!(type2 instanceof GenericArrayType)) continue;
            GenericArrayType arrayType = (GenericArrayType)type2;
            Class rawArrayType = Reflections.getRawType(arrayType);
            beans.addAll(this.getBeans(rawArrayType));
        }
        return beans;
    }

    private List<T> getBeans(Type type2) {
        List beansForType = this.beansByType.get().get(type2);
        return beansForType == null ? Collections.emptyList() : beansForType;
    }

    @Override
    protected BeanManagerImpl getBeanManager() {
        return this.beanManager;
    }

    @Override
    protected Set<T> filterResult(Set<T> matched) {
        return Beans.removeDisabledAndSpecializedBeans(matched, this.beanManager);
    }

    @Override
    protected Set<T> sortResult(Set<T> matched) {
        return matched;
    }

    public <X> Set<Bean<? extends X>> resolve(Set<Bean<? extends X>> beans) {
        if (beans.size() <= 1) {
            return beans;
        }
        beans = ImmutableSet.copyOf(beans);
        return (Set)LoadingCacheUtils.getCastCacheValue(this.disambiguatedBeans, beans);
    }

    @Override
    public void clear() {
        super.clear();
        this.disambiguatedBeans.invalidateAll();
        this.beansByType.clear();
    }

    public static class BeanDisambiguation
    extends CacheLoader<Set<Bean<?>>, Set<Bean<?>>> {
        private BeanDisambiguation() {
        }

        @Override
        public Set<Bean<?>> load(Set<Bean<?>> from) {
            if (from.size() > 1) {
                HashSet allBeans = new HashSet();
                HashSet alternativeBeans = new HashSet();
                for (Bean<?> bean2 : from) {
                    if (bean2.isAlternative()) {
                        alternativeBeans.add(bean2);
                    }
                    allBeans.add(bean2);
                }
                if (alternativeBeans.isEmpty()) {
                    return ImmutableSet.copyOf(allBeans);
                }
                return ImmutableSet.copyOf(alternativeBeans);
            }
            return ImmutableSet.copyOf(from);
        }
    }
}

