/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resolution;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.cache.LoadingCacheUtils;

public class NameBasedResolver {
    private LoadingCache<String, Set<Bean<?>>> resolvedNames;

    public NameBasedResolver(BeanManagerImpl manager, Iterable<? extends Bean<?>> allBeans) {
        this.resolvedNames = CacheBuilder.newBuilder().build(new NameToBeanSet(manager, allBeans));
    }

    public void clear() {
        this.resolvedNames.invalidateAll();
    }

    public Set<Bean<?>> resolve(String name2) {
        return LoadingCacheUtils.getCacheValue(this.resolvedNames, name2);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Resolver\n");
        buffer.append("Resolved names points: " + this.resolvedNames.size() + "\n");
        return buffer.toString();
    }

    private static class NameToBeanSet
    extends CacheLoader<String, Set<Bean<?>>> {
        private final BeanManagerImpl beanManager;
        private final Iterable<? extends Bean<?>> allBeans;

        private NameToBeanSet(BeanManagerImpl beanManager, Iterable<? extends Bean<?>> allBeans) {
            this.beanManager = beanManager;
            this.allBeans = allBeans;
        }

        @Override
        public Set<Bean<?>> load(String from) {
            HashSet matchedBeans = new HashSet();
            for (Bean<?> bean2 : this.allBeans) {
                if ((bean2.getName() != null || from != null) && (bean2.getName() == null || !bean2.getName().equals(from))) continue;
                matchedBeans.add(bean2);
            }
            return ImmutableSet.copyOf(Beans.removeDisabledAndSpecializedBeans(matchedBeans, this.beanManager));
        }
    }
}

