/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.metadata.cache;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.Set;
import javax.enterprise.context.NormalScope;
import javax.inject.Scope;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.ReflectionMessage;
import org.jboss.weld.metadata.cache.AnnotationModel;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.collections.Arrays2;
import org.slf4j.cal10n.LocLogger;

public class ScopeModel<T extends Annotation>
extends AnnotationModel<T> {
    private static final Set<Class<? extends Annotation>> META_ANNOTATIONS = Arrays2.asSet(Scope.class, NormalScope.class);
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.REFLECTION);
    private final boolean normal;
    private final boolean passivating;

    public ScopeModel(Class<T> scope, ClassTransformer classTransformer) {
        super(scope, classTransformer);
        if (this.isValid()) {
            if (this.getAnnotatedAnnotation().isAnnotationPresent(NormalScope.class)) {
                this.passivating = this.getAnnotatedAnnotation().getAnnotation(NormalScope.class).passivating();
                this.normal = true;
            } else {
                this.normal = false;
                this.passivating = false;
            }
        } else {
            this.normal = false;
            this.passivating = false;
        }
    }

    @Override
    protected void check() {
        super.check();
        if (this.isValid()) {
            if (!this.getAnnotatedAnnotation().isAnnotationPresent(Target.class)) {
                log.debug(ReflectionMessage.MISSING_TARGET, this.getAnnotatedAnnotation());
            } else if (!Arrays2.unorderedEquals((Object[])this.getAnnotatedAnnotation().getAnnotation(Target.class).value(), new Object[]{ElementType.METHOD, ElementType.FIELD, ElementType.TYPE})) {
                log.debug(ReflectionMessage.MISSING_TARGET_METHOD_FIELD_TYPE, this.getAnnotatedAnnotation());
            }
        }
    }

    public boolean isNormal() {
        return this.normal;
    }

    public boolean isPassivating() {
        return this.passivating;
    }

    @Override
    protected Set<Class<? extends Annotation>> getMetaAnnotationTypes() {
        return META_ANNOTATIONS;
    }

    @Override
    public String toString() {
        String valid = this.isValid() ? "Valid " : "Invalid";
        String normal = this.isNormal() ? "normal " : "non-normal ";
        String passivating = this.isPassivating() ? "passivating " : "pon-passivating ";
        return valid + normal + passivating + " scope model for " + this.getRawType();
    }
}

