/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.metadata;

import com.google.common.base.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jboss.weld.bootstrap.spi.ClassAvailableActivation;
import org.jboss.weld.bootstrap.spi.Filter;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.bootstrap.spi.SystemPropertyActivation;
import org.jboss.weld.metadata.Selectors;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoadingException;

public class FilterPredicate
implements Predicate<String> {
    private final boolean active;
    private final Pattern pattern;
    private final String name;

    public FilterPredicate(Metadata<Filter> filter2, ResourceLoader resourceLoader) {
        boolean active = true;
        if (filter2.getValue().getClassAvailableActivations() != null) {
            for (Metadata<ClassAvailableActivation> metadata : filter2.getValue().getClassAvailableActivations()) {
                if (metadata.getValue() == null) {
                    throw new IllegalStateException("Class available activation metadata not available at " + metadata);
                }
                String className = metadata.getValue().getClassName();
                if (className == null) {
                    throw new IllegalStateException("Must specify class name at " + metadata);
                }
                boolean inverted = FilterPredicate.isInverted(className);
                if (inverted) {
                    className = FilterPredicate.removeInversion(className);
                }
                active = active && FilterPredicate.isClassAvailable(className, resourceLoader, inverted);
            }
        }
        if (filter2.getValue().getSystemPropertyActivations() != null) {
            for (Metadata<Object> metadata : filter2.getValue().getSystemPropertyActivations()) {
                if (metadata.getValue() == null) {
                    throw new IllegalStateException("System property activation metadata not available at " + metadata);
                }
                String propertyName = ((SystemPropertyActivation)metadata.getValue()).getName();
                String requiredPropertyValue = ((SystemPropertyActivation)metadata.getValue()).getValue();
                if (propertyName == null) {
                    throw new IllegalStateException("Must specify system property name at " + metadata);
                }
                boolean propertyNameInverted = FilterPredicate.isInverted(propertyName);
                if (propertyNameInverted && requiredPropertyValue != null) {
                    throw new IllegalStateException("Cannot invert property name and specify property value at " + metadata);
                }
                if (propertyNameInverted) {
                    propertyName = FilterPredicate.removeInversion(propertyName);
                }
                if (requiredPropertyValue == null) {
                    active = active && FilterPredicate.isNotNull(System.getProperty(propertyName), propertyNameInverted);
                    continue;
                }
                boolean requiredPropertyValueInverted = FilterPredicate.isInverted(requiredPropertyValue);
                if (requiredPropertyValueInverted) {
                    requiredPropertyValue = FilterPredicate.removeInversion(requiredPropertyValue);
                }
                active = active && FilterPredicate.isEqual(requiredPropertyValue, System.getProperty(propertyName), requiredPropertyValueInverted);
            }
        }
        this.active = active;
        if (filter2.getValue().getPattern() != null) {
            this.name = null;
            try {
                this.pattern = Pattern.compile(filter2.getValue().getPattern());
            }
            catch (PatternSyntaxException e2) {
                throw new IllegalStateException("Error parsing pattern at " + filter2, e2);
            }
        } else if (filter2.getValue().getName() != null) {
            this.name = filter2.getValue().getName();
            this.pattern = null;
        } else {
            if (filter2.getValue().getPattern() != null && filter2.getValue().getName() != null) {
                throw new IllegalStateException("Cannot specify both a pattern and a name at " + filter2);
            }
            throw new IllegalStateException("Must specify one of a pattern and a name at " + filter2);
        }
    }

    @Override
    public boolean apply(String className) {
        if (this.active) {
            if (this.pattern != null) {
                return this.pattern.matcher(className).matches();
            }
            return Selectors.matchPath(this.name, className);
        }
        return false;
    }

    private static boolean isClassAvailable(String className, ResourceLoader resourceLoader, boolean invert) {
        if (invert) {
            return !FilterPredicate.isClassAvailable(className, resourceLoader);
        }
        return FilterPredicate.isClassAvailable(className, resourceLoader);
    }

    private static boolean isClassAvailable(String className, ResourceLoader resourceLoader) {
        try {
            resourceLoader.classForName(className);
        }
        catch (ResourceLoadingException e2) {
            return false;
        }
        return true;
    }

    private static boolean isNotNull(String string2, boolean invert) {
        if (invert) {
            return string2 == null;
        }
        return string2 != null;
    }

    private static boolean isEqual(String string1, String string2, boolean invert) {
        if (invert) {
            return !string1.equals(string2);
        }
        return string1.equals(string2);
    }

    private static boolean isInverted(String string2) {
        return string2.startsWith("!");
    }

    private static String removeInversion(String string2) {
        if (!string2.startsWith("!")) {
            throw new IllegalStateException("Cannot remove inversion from non-inverted string [" + string2 + "]");
        }
        return string2.substring(1);
    }
}

