/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.interceptor.reader;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.jboss.weld.interceptor.builder.MethodReference;
import org.jboss.weld.interceptor.reader.AnnotatedMethodReader;
import org.jboss.weld.interceptor.reader.ReflectiveAnnotatedMethodReader;
import org.jboss.weld.interceptor.spi.metadata.MethodMetadata;
import org.jboss.weld.interceptor.spi.model.InterceptionType;
import org.jboss.weld.interceptor.util.InterceptionTypeRegistry;

public class DefaultMethodMetadata<M>
implements MethodMetadata,
Serializable {
    private static final long serialVersionUID = -4538617003189564552L;
    private final Method javaMethod;
    private final Set<InterceptionType> supportedInterceptorTypes;

    private DefaultMethodMetadata(M methodReference, AnnotatedMethodReader<M> annotationReader) {
        this.supportedInterceptorTypes = new HashSet<InterceptionType>();
        this.javaMethod = annotationReader.getJavaMethod(methodReference);
        for (InterceptionType interceptionType : InterceptionTypeRegistry.getSupportedInterceptionTypes()) {
            if (annotationReader.getAnnotation(InterceptionTypeRegistry.getAnnotationClass(interceptionType), methodReference) == null) continue;
            this.supportedInterceptorTypes.add(interceptionType);
        }
    }

    private DefaultMethodMetadata(Set<InterceptionType> interceptionTypes, MethodReference methodReference) {
        this.supportedInterceptorTypes = interceptionTypes;
        try {
            this.javaMethod = methodReference.getDeclaringClass().getDeclaredMethod(methodReference.getMethodName(), methodReference.getParameterTypes());
        }
        catch (NoSuchMethodException e2) {
            throw new IllegalStateException(e2);
        }
    }

    public static <M> MethodMetadata of(M methodReference, AnnotatedMethodReader<M> methodReader) {
        return new DefaultMethodMetadata<M>(methodReference, methodReader);
    }

    public static MethodMetadata of(Method method) {
        return new DefaultMethodMetadata<Method>(method, new ReflectiveAnnotatedMethodReader());
    }

    @Override
    public Set<InterceptionType> getSupportedInterceptionTypes() {
        return this.supportedInterceptorTypes;
    }

    @Override
    public Method getJavaMethod() {
        return this.javaMethod;
    }

    @Override
    public Class<?> getReturnType() {
        return this.javaMethod.getReturnType();
    }

    private Object writeReplace() {
        return new DefaultMethodMetadataSerializationProxy(this.supportedInterceptorTypes, MethodReference.of(this, true));
    }

    private static class DefaultMethodMetadataSerializationProxy
    implements Serializable {
        private final Set<InterceptionType> supportedInterceptionTypes;
        private final MethodReference methodReference;

        private DefaultMethodMetadataSerializationProxy(Set<InterceptionType> supportedInterceptionTypes, MethodReference methodReference) {
            this.supportedInterceptionTypes = supportedInterceptionTypes;
            this.methodReference = methodReference;
        }

        private Object readResolve() throws ObjectStreamException {
            return new DefaultMethodMetadata(this.supportedInterceptionTypes, this.methodReference);
        }
    }
}

