/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection.spi.helpers;

import java.beans.Introspector;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.annotation.Resource;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.weld.bootstrap.api.Service;

public abstract class AbstractResourceServices
implements Service {
    private static final String RESOURCE_LOOKUP_PREFIX = "java:comp/env";

    public Object resolveResource(InjectionPoint injectionPoint) {
        if (!injectionPoint.getAnnotated().isAnnotationPresent(Resource.class)) {
            throw new IllegalArgumentException("No @Resource annotation found on injection point " + injectionPoint);
        }
        if (injectionPoint.getMember() instanceof Method && ((Method)injectionPoint.getMember()).getParameterTypes().length != 1) {
            throw new IllegalArgumentException("Injection point represents a method which doesn't follow JavaBean conventions (must have exactly one parameter) " + injectionPoint);
        }
        String name2 = this.getResourceName(injectionPoint);
        try {
            return this.getContext().lookup(name2);
        }
        catch (NamingException e2) {
            throw new RuntimeException("Error looking up " + name2 + " in JNDI", e2);
        }
    }

    public Object resolveResource(String jndiName, String mappedName) {
        String name2 = this.getResourceName(jndiName, mappedName);
        try {
            return this.getContext().lookup(name2);
        }
        catch (NamingException e2) {
            throw new RuntimeException("Error looking up " + name2 + " in JNDI", e2);
        }
    }

    protected String getResourceName(String jndiName, String mappedName) {
        if (mappedName != null) {
            return mappedName;
        }
        if (jndiName != null) {
            return jndiName;
        }
        throw new IllegalArgumentException("Both jndiName and mappedName are null");
    }

    protected abstract Context getContext();

    protected String getResourceName(InjectionPoint injectionPoint) {
        String propertyName;
        Resource resource2 = injectionPoint.getAnnotated().getAnnotation(Resource.class);
        String mappedName = resource2.mappedName();
        if (!mappedName.equals("")) {
            return mappedName;
        }
        String name2 = resource2.name();
        if (!name2.equals("")) {
            return "java:comp/env/" + name2;
        }
        if (injectionPoint.getMember() instanceof Field) {
            propertyName = injectionPoint.getMember().getName();
        } else if (injectionPoint.getMember() instanceof Method) {
            propertyName = AbstractResourceServices.getPropertyName((Method)injectionPoint.getMember());
            if (propertyName == null) {
                throw new IllegalArgumentException("Injection point represents a method which doesn't follow JavaBean conventions (unable to determine property name) " + injectionPoint);
            }
        } else {
            throw new AssertionError((Object)("Unable to inject into " + injectionPoint));
        }
        String className = injectionPoint.getMember().getDeclaringClass().getName();
        return "java:comp/env/" + className + "/" + propertyName;
    }

    public static String getPropertyName(Method method) {
        String methodName = method.getName();
        if (methodName.matches("^(get).*") && method.getParameterTypes().length == 0) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        if (methodName.matches("^(is).*") && method.getParameterTypes().length == 0) {
            return Introspector.decapitalize(methodName.substring(2));
        }
        return null;
    }

    public void cleanup() {
    }
}

