/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context.beanstore.http;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jboss.weld.context.beanstore.NamingScheme;
import org.jboss.weld.context.beanstore.http.LazySessionBeanStore;
import org.jboss.weld.util.collections.EnumerationList;
import org.jboss.weld.util.reflection.Reflections;

public class LazyCyclicSessionBeanStore
extends LazySessionBeanStore {
    private static ThreadLocal<Map<String, Object>> temp = new ThreadLocal();

    public LazyCyclicSessionBeanStore(HttpServletRequest request, NamingScheme namingScheme) {
        super(request, namingScheme);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected HttpSession getSession(boolean create) {
        boolean newTemp;
        HttpSession session = null;
        Map<String, Object> map2 = temp.get();
        boolean bl = newTemp = create && map2 == null;
        if (newTemp) {
            map2 = new HashMap<String, Object>();
            temp.set(map2);
        }
        try {
            HttpSession httpSession = session = super.getSession(create);
            return httpSession;
        }
        finally {
            if (create) {
                if (newTemp) {
                    temp.remove();
                }
                if (session != null && !map2.isEmpty()) {
                    for (Map.Entry<String, Object> entry : map2.entrySet()) {
                        session.setAttribute(entry.getKey(), entry.getValue());
                    }
                }
            }
        }
    }

    @Override
    protected Collection<String> getAttributeNames() {
        Map<String, Object> map2 = temp.get();
        if (map2 != null) {
            HashSet<String> names = new HashSet<String>();
            names.addAll(map2.keySet());
            HttpSession session = this.getSessionIfExists();
            if (session != null) {
                names.addAll(new EnumerationList((Enumeration)Reflections.cast(session.getAttributeNames())));
            }
            return names;
        }
        return super.getAttributeNames();
    }

    @Override
    protected void removeAttribute(String key2) {
        Map<String, Object> map2 = temp.get();
        if (map2 != null) {
            map2.remove(key2);
            HttpSession session = this.getSessionIfExists();
            if (session != null) {
                session.removeAttribute(key2);
            }
        } else {
            super.removeAttribute(key2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setAttribute(String key2, Object instance) {
        Map<String, Object> map2 = temp.get();
        boolean created = map2 == null;
        try {
            if (map2 == null) {
                map2 = new HashMap<String, Object>();
                map2.put(key2, instance);
                temp.set(map2);
                super.setAttribute(key2, instance);
            } else {
                map2.put(key2, instance);
            }
        }
        finally {
            if (created) {
                temp.remove();
            }
        }
    }

    @Override
    protected Object getAttribute(String prefixedId) {
        Map<String, Object> map2 = temp.get();
        if (map2 != null) {
            Object value = map2.get(prefixedId);
            if (value != null) {
                return value;
            }
            HttpSession session = this.getSessionIfExists();
            if (session != null) {
                return session.getAttribute(prefixedId);
            }
            return null;
        }
        return super.getAttribute(prefixedId);
    }
}

