/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.spi.Context;
import javax.enterprise.inject.spi.Extension;
import org.jboss.weld.Container;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bean.builtin.ExtensionBean;
import org.jboss.weld.bootstrap.BeanDeployment;
import org.jboss.weld.bootstrap.ContextHolder;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.event.ObserverFactory;
import org.jboss.weld.event.ObserverMethodImpl;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BootstrapMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.resources.spi.ResourceLoadingException;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.DeploymentStructures;
import org.jboss.weld.util.reflection.Reflections;
import org.slf4j.cal10n.LocLogger;
import org.slf4j.ext.XLogger;

public class ExtensionBeanDeployer {
    private transient LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.CLASS_LOADING);
    private transient XLogger xlog = LoggerFactory.loggerFactory().getXLogger(Category.CLASS_LOADING);
    private final BeanManagerImpl beanManager;
    private final Set<Metadata<Extension>> extensions;
    private final Deployment deployment;
    private final Map<BeanDeploymentArchive, BeanDeployment> beanDeployments;
    private final Collection<ContextHolder<? extends Context>> contexts;

    public ExtensionBeanDeployer(BeanManagerImpl manager, Deployment deployment, Map<BeanDeploymentArchive, BeanDeployment> beanDeployments, Collection<ContextHolder<? extends Context>> contexts) {
        this.beanManager = manager;
        this.extensions = new HashSet<Metadata<Extension>>();
        this.deployment = deployment;
        this.beanDeployments = beanDeployments;
        this.contexts = contexts;
    }

    public ExtensionBeanDeployer deployBeans() {
        ClassTransformer classTransformer = Container.instance().services().get(ClassTransformer.class);
        for (Metadata<Extension> extension : this.extensions) {
            WeldClass clazz = null;
            try {
                clazz = (WeldClass)Reflections.cast(classTransformer.loadClass(extension.getValue().getClass()));
            }
            catch (ResourceLoadingException e2) {
                this.log.warn(BootstrapMessage.IGNORING_EXTENSION_CLASS_DUE_TO_LOADING_ERROR, extension.getValue().getClass().getName());
                this.xlog.catching(XLogger.Level.DEBUG, e2);
            }
            if (clazz == null) continue;
            BeanDeployment beanDeployment = DeploymentStructures.getOrCreateBeanDeployment(this.deployment, this.beanManager, this.beanDeployments, this.contexts, clazz.getJavaClass());
            ExtensionBean bean2 = new ExtensionBean(beanDeployment.getBeanManager(), clazz, extension);
            HashSet observerMethods = new HashSet();
            this.createObserverMethods(bean2, beanDeployment.getBeanManager(), clazz, observerMethods);
            beanDeployment.getBeanManager().addBean(bean2);
            beanDeployment.getBeanDeployer().addExtension(bean2);
            for (ObserverMethodImpl observerMethodImpl : observerMethods) {
                observerMethodImpl.initialize();
                beanDeployment.getBeanManager().addObserver(observerMethodImpl);
            }
        }
        return this;
    }

    public void addExtensions(Iterable<Metadata<Extension>> extensions) {
        for (Metadata<Extension> extension : extensions) {
            this.addExtension(extension);
        }
    }

    public void addExtension(Metadata<Extension> extension) {
        this.extensions.add(extension);
    }

    protected <X> void createObserverMethods(RIBean<X> declaringBean, BeanManagerImpl beanManager, WeldClass<? super X> annotatedClass, Set<ObserverMethodImpl<?, ?>> observerMethods) {
        for (WeldMethod<?, ? super X> weldMethod : Beans.getObserverMethods(annotatedClass)) {
            this.createObserverMethod(declaringBean, beanManager, weldMethod, observerMethods);
        }
    }

    protected <T, X> void createObserverMethod(RIBean<X> declaringBean, BeanManagerImpl beanManager, WeldMethod<T, ? super X> method, Set<ObserverMethodImpl<?, ?>> observerMethods) {
        ObserverMethodImpl<T, ? super X> observer = ObserverFactory.create(method, declaringBean, beanManager);
        observerMethods.add(observer);
    }
}

