/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.bean.proxy.BeanInstance;
import org.jboss.weld.injection.Exceptions;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.util.Proxies;
import org.jboss.weld.util.reflection.SecureReflections;
import org.slf4j.cal10n.LocLogger;

public abstract class AbstractBeanInstance
implements BeanInstance {
    protected static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BEAN);

    @Override
    public Object invoke(Object instance, Method method, Object ... arguments) throws Throwable {
        Object result = null;
        try {
            SecureReflections.ensureAccessible(method);
            result = method.invoke(instance, arguments);
        }
        catch (InvocationTargetException e2) {
            throw Exceptions.unwrapIfPossible(e2);
        }
        return result;
    }

    protected Class<?> computeInstanceType(Bean<?> bean2) {
        return this.computeInstanceType(bean2.getTypes());
    }

    protected Class<?> computeInstanceType(Set<Type> types) {
        Proxies.TypeInfo typeInfo = Proxies.TypeInfo.of(types);
        Class<?> superClass = typeInfo.getSuperClass();
        if (superClass.equals(Object.class)) {
            superClass = typeInfo.getSuperInterface();
        }
        return superClass;
    }
}

