/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.interceptor;

import java.lang.reflect.Constructor;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionTarget;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.interceptor.spi.instance.InterceptorInstantiator;
import org.jboss.weld.interceptor.spi.metadata.ClassMetadata;
import org.jboss.weld.interceptor.spi.metadata.InterceptorReference;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.serialization.spi.helpers.SerializableContextual;
import org.jboss.weld.util.reflection.Reflections;
import org.jboss.weld.util.reflection.SecureReflections;

public class WeldInterceptorInstantiator<T>
implements InterceptorInstantiator<T, Object> {
    private BeanManagerImpl manager;
    private CreationalContext<T> creationalContext;

    public WeldInterceptorInstantiator(BeanManagerImpl manager, CreationalContext<T> creationalContext) {
        this.manager = manager;
        this.creationalContext = creationalContext;
    }

    @Override
    public T createFor(InterceptorReference<Object> interceptorReference) {
        if (interceptorReference.getInterceptor() instanceof ClassMetadata) {
            try {
                Class clazz = (Class)Reflections.cast(interceptorReference.getClassMetadata().getJavaClass());
                Constructor constructor = SecureReflections.getDeclaredConstructor(clazz, new Class[0]);
                Object interceptorInstance = SecureReflections.ensureAccessible(constructor).newInstance(new Object[0]);
                AnnotatedType type2 = this.manager.createAnnotatedType(clazz);
                InjectionTarget target = this.manager.createInjectionTarget(type2);
                target.inject(interceptorInstance, this.creationalContext);
                return interceptorInstance;
            }
            catch (Exception e2) {
                throw new DeploymentException(e2);
            }
        }
        if (interceptorReference.getInterceptor() instanceof SerializableContextual) {
            try {
                SerializableContextual serializableContextual = (SerializableContextual)Reflections.cast(interceptorReference.getInterceptor());
                return Reflections.cast(this.manager.getReference((Bean)serializableContextual.get(), this.creationalContext, false));
            }
            catch (Exception e3) {
                throw new DeploymentException(e3);
            }
        }
        throw new IllegalStateException();
    }
}

