/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging;

import java.util.Locale;
import org.jboss.logging.SecurityActions;

class LoggingLocale {
    private static final Locale LOCALE = LoggingLocale.getDefaultLocale();

    LoggingLocale() {
    }

    static Locale getLocale() {
        return LOCALE;
    }

    private static Locale getDefaultLocale() {
        String bcp47Tag = SecurityActions.getSystemProperty("org.jboss.logging.locale", "");
        if (bcp47Tag.trim().isEmpty()) {
            return Locale.getDefault();
        }
        return LoggingLocale.forLanguageTag(bcp47Tag);
    }

    private static Locale forLanguageTag(String locale) {
        if ("en-CA".equalsIgnoreCase(locale)) {
            return Locale.CANADA;
        }
        if ("fr-CA".equalsIgnoreCase(locale)) {
            return Locale.CANADA_FRENCH;
        }
        if ("zh".equalsIgnoreCase(locale)) {
            return Locale.CHINESE;
        }
        if ("en".equalsIgnoreCase(locale)) {
            return Locale.ENGLISH;
        }
        if ("fr-FR".equalsIgnoreCase(locale)) {
            return Locale.FRANCE;
        }
        if ("fr".equalsIgnoreCase(locale)) {
            return Locale.FRENCH;
        }
        if ("de".equalsIgnoreCase(locale)) {
            return Locale.GERMAN;
        }
        if ("de-DE".equalsIgnoreCase(locale)) {
            return Locale.GERMANY;
        }
        if ("it".equalsIgnoreCase(locale)) {
            return Locale.ITALIAN;
        }
        if ("it-IT".equalsIgnoreCase(locale)) {
            return Locale.ITALY;
        }
        if ("ja-JP".equalsIgnoreCase(locale)) {
            return Locale.JAPAN;
        }
        if ("ja".equalsIgnoreCase(locale)) {
            return Locale.JAPANESE;
        }
        if ("ko-KR".equalsIgnoreCase(locale)) {
            return Locale.KOREA;
        }
        if ("ko".equalsIgnoreCase(locale)) {
            return Locale.KOREAN;
        }
        if ("zh-CN".equalsIgnoreCase(locale)) {
            return Locale.SIMPLIFIED_CHINESE;
        }
        if ("zh-TW".equalsIgnoreCase(locale)) {
            return Locale.TRADITIONAL_CHINESE;
        }
        if ("en-UK".equalsIgnoreCase(locale)) {
            return Locale.UK;
        }
        if ("en-US".equalsIgnoreCase(locale)) {
            return Locale.US;
        }
        String[] parts = locale.split("-");
        int len = parts.length;
        int index2 = 0;
        int count2 = 0;
        String language = parts[index2++];
        String region = "";
        String variant = "";
        while (index2 < len && count2++ != 2 && LoggingLocale.isAlpha(parts[index2], 3, 3)) {
            ++index2;
        }
        if (index2 != len && LoggingLocale.isAlpha(parts[index2], 4, 4)) {
            ++index2;
        }
        if (index2 != len && (LoggingLocale.isAlpha(parts[index2], 2, 2) || LoggingLocale.isNumeric(parts[index2], 3, 3))) {
            region = parts[index2++];
        }
        if (index2 != len && LoggingLocale.isAlphaOrNumeric(parts[index2], 5, 8)) {
            variant = parts[index2];
        }
        return new Locale(language, region, variant);
    }

    private static boolean isAlpha(String value, int minLen, int maxLen) {
        int len = value.length();
        if (len < minLen || len > maxLen) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (Character.isLetter(value.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isNumeric(String value, int minLen, int maxLen) {
        int len = value.length();
        if (len < minLen || len > maxLen) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (Character.isDigit(value.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isAlphaOrNumeric(String value, int minLen, int maxLen) {
        int len = value.length();
        if (len < minLen || len > maxLen) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (Character.isLetterOrDigit(value.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

