/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.interceptor.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jboss.interceptor.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionFactoryUtils {
    private static Object reflectionFactory = null;
    private static Method newConstructorForSerialization = null;

    public static boolean isAvailable() {
        return reflectionFactory != null && newConstructorForSerialization != null;
    }

    public static <T> Constructor<T> getReflectionFactoryConstructor(Class<T> proxyClass) throws NoSuchMethodException {
        if (ReflectionFactoryUtils.isAvailable()) {
            try {
                return (Constructor)newConstructorForSerialization.invoke(reflectionFactory, proxyClass, Object.class.getDeclaredConstructor(new Class[0]));
            }
            catch (NoSuchMethodException e2) {
                return null;
            }
            catch (SecurityException e3) {
                return null;
            }
            catch (IllegalAccessException e4) {
                return null;
            }
            catch (InvocationTargetException e5) {
                return null;
            }
        }
        return null;
    }

    static {
        try {
            Class<?> reflectionFactoryClass = Class.forName("sun.reflect.ReflectionFactory");
            Method getReflectionFactory = reflectionFactoryClass.getDeclaredMethod("getReflectionFactory", new Class[0]);
            ReflectionUtils.ensureAccessible(getReflectionFactory);
            reflectionFactory = getReflectionFactory.invoke(null, new Object[0]);
            newConstructorForSerialization = reflectionFactoryClass.getDeclaredMethod("newConstructorForSerialization", Class.class, Constructor.class);
            ReflectionUtils.ensureAccessible(newConstructorForSerialization);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

