/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.interceptor.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.Callable;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import org.jboss.interceptor.proxy.InterceptorException;
import org.jboss.interceptor.proxy.LifecycleMixin;
import org.jboss.interceptor.spi.metadata.ClassMetadata;
import org.jboss.interceptor.spi.model.InterceptionType;
import org.jboss.interceptor.util.InterceptionTypeRegistry;
import org.jboss.interceptor.util.proxy.TargetInstanceProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptionUtils {
    public static final String POST_CONSTRUCT = "lifecycle_mixin_$$_postConstruct";
    public static final String PRE_DESTROY = "lifecycle_mixin_$$_preDestroy";
    private static Class<? extends Annotation> INTERCEPTORS_ANNOTATION_CLASS = null;
    private static Class<? extends Annotation> EXCLUDE_CLASS_INTERCEPTORS_ANNOTATION_CLASS = null;

    public static void executePostConstruct(Object proxy2, Callable callback) {
        if (proxy2 instanceof LifecycleMixin) {
            LifecycleMixin lifecycleMixin = (LifecycleMixin)proxy2;
            lifecycleMixin.lifecycle_mixin_$$_postConstruct();
        }
        if (callback != null) {
            try {
                callback.call();
            }
            catch (Exception e2) {
                throw new InterceptorException(e2);
            }
        }
    }

    public static void executePostConstruct(Object proxy2) {
        InterceptionUtils.executePostConstruct(proxy2, null);
    }

    public static void executePredestroy(Object proxy2, Callable callback) {
        if (proxy2 instanceof LifecycleMixin) {
            LifecycleMixin lifecycleMixin = (LifecycleMixin)proxy2;
            lifecycleMixin.lifecycle_mixin_$$_preDestroy();
        }
        if (callback != null) {
            try {
                callback.call();
            }
            catch (Exception e2) {
                throw new InterceptorException(e2);
            }
        }
    }

    public static void executePredestroy(Object proxy2) {
        InterceptionUtils.executePredestroy(proxy2, null);
    }

    public static boolean isInterceptionCandidate(Method method) {
        if (method.getDeclaringClass().equals(Object.class)) {
            return false;
        }
        int modifiers = method.getModifiers();
        if (Modifier.isStatic(modifiers)) {
            return false;
        }
        for (InterceptionType interceptionType : InterceptionTypeRegistry.getSupportedInterceptionTypes()) {
            if (method.getAnnotation(InterceptionTypeRegistry.getAnnotationClass(interceptionType)) == null) continue;
            return false;
        }
        return true;
    }

    public static boolean supportsEjb3InterceptorDeclaration() {
        return INTERCEPTORS_ANNOTATION_CLASS != null && EXCLUDE_CLASS_INTERCEPTORS_ANNOTATION_CLASS != null;
    }

    public static Class<? extends Annotation> getInterceptorsAnnotationClass() {
        return INTERCEPTORS_ANNOTATION_CLASS;
    }

    public static Class<? extends Annotation> getExcludeClassInterceptorsAnnotationClass() {
        return EXCLUDE_CLASS_INTERCEPTORS_ANNOTATION_CLASS;
    }

    public static <T> Class<T> createProxyClass(Class<T> proxyClass, boolean forSubclassing) {
        ProxyFactory proxyFactory = new ProxyFactory();
        if (proxyClass != null) {
            proxyFactory.setSuperclass(proxyClass);
            proxyFactory.setUseWriteReplace(false);
        }
        if (forSubclassing) {
            proxyFactory.setInterfaces(new Class[]{LifecycleMixin.class, TargetInstanceProxy.class});
        } else {
            proxyFactory.setInterfaces(new Class[]{LifecycleMixin.class, TargetInstanceProxy.class});
        }
        Class<?> clazz = proxyFactory.createClass();
        return clazz;
    }

    public static <T> Class<T> createProxyClassWithHandler(ClassMetadata<T> proxyClass, MethodHandler methodHandler) {
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setUseWriteReplace(false);
        if (proxyClass != null) {
            proxyFactory.setSuperclass(proxyClass.getJavaClass());
        }
        proxyFactory.setInterfaces(new Class[]{LifecycleMixin.class, TargetInstanceProxy.class});
        proxyFactory.setHandler(methodHandler);
        Class<?> clazz = proxyFactory.createClass();
        return clazz;
    }

    static {
        try {
            INTERCEPTORS_ANNOTATION_CLASS = Class.forName("javax.interceptor.Interceptors");
            EXCLUDE_CLASS_INTERCEPTORS_ANNOTATION_CLASS = Class.forName("javax.interceptor.ExcludeClassInterceptors");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

