/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.interceptor.proxy;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.interceptor.InvocationContext;
import org.jboss.interceptor.proxy.InterceptorException;
import org.jboss.interceptor.spi.context.InterceptionChain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorInvocationContext
implements InvocationContext {
    private Map<String, Object> contextData = new HashMap<String, Object>();
    private Method method;
    private Object[] parameters;
    private Object target;
    private InterceptionChain interceptionChain;
    private Object timer;
    private static Map<Class<?>, Set<Class<?>>> WIDENING_TABLE;
    private static Map<Class<?>, Class<?>> WRAPPER_CLASSES;
    private static Map<Class<?>, Class<?>> REVERSE_WRAPPER_CLASSES;

    private static Set<Class<?>> setOf(Class<?> ... classes) {
        return new HashSet(Arrays.asList(classes));
    }

    public InterceptorInvocationContext(InterceptionChain interceptionChain, Object target, Method targetMethod, Object[] parameters) {
        this.interceptionChain = interceptionChain;
        this.method = targetMethod;
        this.parameters = parameters;
        this.target = target;
        this.timer = null;
    }

    public InterceptorInvocationContext(InterceptionChain interceptionChain, Object target, Method targetMethod, Object timer) {
        this.interceptionChain = interceptionChain;
        this.method = targetMethod;
        this.timer = timer;
        this.target = target;
        this.parameters = null;
    }

    @Override
    public Map<String, Object> getContextData() {
        return this.contextData;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public Object[] getParameters() {
        if (this.method != null) {
            return this.parameters;
        }
        throw new IllegalStateException("Illegal invocation to getParameters() during lifecycle invocation");
    }

    @Override
    public Object getTarget() {
        return this.target;
    }

    @Override
    public Object proceed() throws Exception {
        try {
            return this.interceptionChain.invokeNextInterceptor(this);
        }
        catch (Exception e2) {
            throw e2;
        }
        catch (Throwable t) {
            throw new InterceptorException(t);
        }
    }

    private static boolean isWideningPrimitive(Class argumentClass, Class targetClass) {
        return WIDENING_TABLE.containsKey(argumentClass) && WIDENING_TABLE.get(argumentClass).contains(targetClass);
    }

    private static Class<?> getWrapperClass(Class<?> primitiveClass) {
        if (!WRAPPER_CLASSES.containsKey(primitiveClass)) {
            return primitiveClass;
        }
        return WRAPPER_CLASSES.get(primitiveClass);
    }

    private static Class<?> getPrimitiveClass(Class<?> wrapperClass) {
        if (!REVERSE_WRAPPER_CLASSES.containsKey(wrapperClass)) {
            return wrapperClass;
        }
        return REVERSE_WRAPPER_CLASSES.get(wrapperClass);
    }

    @Override
    public void setParameters(Object[] params) {
        if (this.method != null) {
            int newParametersCount;
            int n = newParametersCount = params == null ? 0 : params.length;
            if (this.method.getParameterTypes().length != newParametersCount) {
                throw new IllegalArgumentException("Wrong number of parameters: method has " + this.method.getParameterTypes().length + ", attempting to set " + newParametersCount + (params != null ? "" : " (argument was null)"));
            }
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    Class<?> methodParameterClass = this.method.getParameterTypes()[i];
                    if (params[i] != null) {
                        Class<?> unboxedClass;
                        Class<?> boxedArgumentClass;
                        Class<?> newArgumentClass = params[i].getClass();
                        if (newArgumentClass.equals(methodParameterClass)) break;
                        if (!(newArgumentClass.isPrimitive() ? (methodParameterClass.isPrimitive() ? !InterceptorInvocationContext.isWideningPrimitive(newArgumentClass, methodParameterClass) : !methodParameterClass.isAssignableFrom(boxedArgumentClass = InterceptorInvocationContext.getWrapperClass(newArgumentClass))) : (methodParameterClass.isPrimitive() ? !(unboxedClass = InterceptorInvocationContext.getPrimitiveClass(newArgumentClass)).equals(methodParameterClass) && !InterceptorInvocationContext.isWideningPrimitive(unboxedClass, methodParameterClass) : !methodParameterClass.isAssignableFrom(newArgumentClass)))) continue;
                        throw new IllegalArgumentException("Incompatible parameter type on position: " + i + " :" + newArgumentClass + " (expected type was " + methodParameterClass.getName() + ")");
                    }
                    if (!this.method.getParameterTypes()[i].isPrimitive()) continue;
                    throw new IllegalArgumentException("Trying to set a null value on a " + this.method.getParameterTypes()[i].getName());
                }
                this.parameters = params;
            }
        } else {
            throw new IllegalStateException("Illegal invocation to setParameters() during lifecycle invocation");
        }
    }

    @Override
    public Object getTimer() {
        return this.timer;
    }

    static {
        WRAPPER_CLASSES = new HashMap();
        WRAPPER_CLASSES.put(Boolean.TYPE, Boolean.class);
        WRAPPER_CLASSES.put(Byte.TYPE, Byte.class);
        WRAPPER_CLASSES.put(Character.TYPE, Character.class);
        WRAPPER_CLASSES.put(Short.TYPE, Short.class);
        WRAPPER_CLASSES.put(Integer.TYPE, Integer.class);
        WRAPPER_CLASSES.put(Long.TYPE, Long.class);
        WRAPPER_CLASSES.put(Float.TYPE, Float.class);
        WRAPPER_CLASSES.put(Double.TYPE, Double.class);
        WRAPPER_CLASSES = Collections.unmodifiableMap(WRAPPER_CLASSES);
        REVERSE_WRAPPER_CLASSES = new HashMap();
        for (Map.Entry<Class<?>, Class<?>> classEntry : WRAPPER_CLASSES.entrySet()) {
            REVERSE_WRAPPER_CLASSES.put(classEntry.getValue(), classEntry.getKey());
        }
        REVERSE_WRAPPER_CLASSES = Collections.unmodifiableMap(REVERSE_WRAPPER_CLASSES);
        WIDENING_TABLE = new HashMap();
        WIDENING_TABLE.put(Byte.TYPE, InterceptorInvocationContext.setOf(Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE));
        WIDENING_TABLE.put(Short.TYPE, InterceptorInvocationContext.setOf(Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE));
        WIDENING_TABLE.put(Character.TYPE, InterceptorInvocationContext.setOf(Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE));
        WIDENING_TABLE.put(Integer.TYPE, InterceptorInvocationContext.setOf(Long.TYPE, Float.TYPE, Double.TYPE));
        WIDENING_TABLE.put(Long.TYPE, InterceptorInvocationContext.setOf(Float.TYPE, Double.TYPE));
        WIDENING_TABLE.put(Float.TYPE, Collections.singleton(Double.TYPE));
    }
}

