/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.modeler.modules;

import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.modeler.AttributeInfo;
import org.apache.tomcat.util.modeler.ManagedBean;
import org.apache.tomcat.util.modeler.OperationInfo;
import org.apache.tomcat.util.modeler.ParameterInfo;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.modeler.modules.ModelerSource;

public class MbeansDescriptorsIntrospectionSource
extends ModelerSource {
    private static final Log log = LogFactory.getLog(MbeansDescriptorsIntrospectionSource.class);
    private Registry registry;
    private String type;
    private final List<ObjectName> mbeans = new ArrayList<ObjectName>();
    private static final Hashtable<String, String> specialMethods = new Hashtable();
    private static final Class<?>[] supportedTypes;

    public void setRegistry(Registry reg) {
        this.registry = reg;
    }

    public void setType(String type2) {
        this.type = type2;
    }

    public void setSource(Object source2) {
        this.source = source2;
    }

    @Override
    public List<ObjectName> loadDescriptors(Registry registry, String type2, Object source2) throws Exception {
        this.setRegistry(registry);
        this.setType(type2);
        this.setSource(source2);
        this.execute();
        return this.mbeans;
    }

    public void execute() throws Exception {
        if (this.registry == null) {
            this.registry = Registry.getRegistry(null, null);
        }
        try {
            ManagedBean managed = this.createManagedBean(this.registry, null, (Class)this.source, this.type);
            if (managed == null) {
                return;
            }
            managed.setName(this.type);
            this.registry.addManagedBean(managed);
        }
        catch (Exception ex) {
            log.error(sm.getString("modules.readDescriptorsError"), ex);
        }
    }

    private boolean supportedType(Class<?> ret) {
        for (Class<?> supportedType : supportedTypes) {
            if (ret != supportedType) continue;
            return true;
        }
        return this.isBeanCompatible(ret);
    }

    private boolean isBeanCompatible(Class<?> javaType) {
        if (javaType.isArray() || javaType.isPrimitive()) {
            return false;
        }
        if (javaType.getName().startsWith("java.") || javaType.getName().startsWith("javax.")) {
            return false;
        }
        try {
            javaType.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e2) {
            return false;
        }
        Class<?> superClass = javaType.getSuperclass();
        return superClass == null || superClass == Object.class || superClass == Exception.class || superClass == Throwable.class || this.isBeanCompatible(superClass);
    }

    private void initMethods(Class<?> realClass, Method[] methods2, Hashtable<String, Method> attMap, Hashtable<String, Method> getAttMap, Hashtable<String, Method> setAttMap, Hashtable<String, Method> invokeAttMap) {
        for (Method method : methods2) {
            String name2 = method.getName();
            if (Modifier.isStatic(method.getModifiers())) continue;
            if (!Modifier.isPublic(method.getModifiers())) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Not public " + method);
                continue;
            }
            if (method.getDeclaringClass() == Object.class) continue;
            Class<?>[] params = method.getParameterTypes();
            if (name2.startsWith("get") && params.length == 0) {
                Class<?> ret = method.getReturnType();
                if (!this.supportedType(ret)) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Unsupported type " + method);
                    continue;
                }
                name2 = MbeansDescriptorsIntrospectionSource.unCapitalize(name2.substring(3));
                getAttMap.put(name2, method);
                attMap.put(name2, method);
                continue;
            }
            if (name2.startsWith("is") && params.length == 0) {
                Class<?> ret = method.getReturnType();
                if (Boolean.TYPE != ret) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Unsupported type " + method + " " + ret);
                    continue;
                }
                name2 = MbeansDescriptorsIntrospectionSource.unCapitalize(name2.substring(2));
                getAttMap.put(name2, method);
                attMap.put(name2, method);
                continue;
            }
            if (name2.startsWith("set") && params.length == 1) {
                if (!this.supportedType(params[0])) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Unsupported type " + method + " " + params[0]);
                    continue;
                }
                name2 = MbeansDescriptorsIntrospectionSource.unCapitalize(name2.substring(3));
                setAttMap.put(name2, method);
                attMap.put(name2, method);
                continue;
            }
            if (params.length == 0) {
                if (specialMethods.get(method.getName()) != null) continue;
                invokeAttMap.put(name2, method);
                continue;
            }
            boolean supported = true;
            for (Class<?> param : params) {
                if (this.supportedType(param)) continue;
                supported = false;
                break;
            }
            if (!supported) continue;
            invokeAttMap.put(name2, method);
        }
    }

    public ManagedBean createManagedBean(Registry registry, String domain, Class<?> realClass, String type2) {
        ManagedBean mbean = new ManagedBean();
        Method[] methods2 = null;
        Hashtable<String, Method> attMap = new Hashtable<String, Method>();
        Hashtable<String, Method> getAttMap = new Hashtable<String, Method>();
        Hashtable<String, Method> setAttMap = new Hashtable<String, Method>();
        Hashtable<String, Method> invokeAttMap = new Hashtable<String, Method>();
        methods2 = realClass.getMethods();
        this.initMethods(realClass, methods2, attMap, getAttMap, setAttMap, invokeAttMap);
        try {
            Enumeration<String> en = attMap.keys();
            while (en.hasMoreElements()) {
                Method sm;
                String name2 = en.nextElement();
                AttributeInfo ai = new AttributeInfo();
                ai.setName(name2);
                Method gm = getAttMap.get(name2);
                if (gm != null) {
                    ai.setGetMethod(gm.getName());
                    Class<?> t = gm.getReturnType();
                    if (t != null) {
                        ai.setType(t.getName());
                    }
                }
                if ((sm = setAttMap.get(name2)) != null) {
                    Class<?> t = sm.getParameterTypes()[0];
                    if (t != null) {
                        ai.setType(t.getName());
                    }
                    ai.setSetMethod(sm.getName());
                }
                ai.setDescription("Introspected attribute " + name2);
                if (log.isDebugEnabled()) {
                    log.debug("Introspected attribute " + name2 + " " + gm + " " + sm);
                }
                if (gm == null) {
                    ai.setReadable(false);
                }
                if (sm == null) {
                    ai.setWriteable(false);
                }
                if (sm == null && gm == null) continue;
                mbean.addAttribute(ai);
            }
            for (Map.Entry<String, Method> entry : invokeAttMap.entrySet()) {
                String name3 = entry.getKey();
                Method m = entry.getValue();
                OperationInfo op = new OperationInfo();
                op.setName(name3);
                op.setReturnType(m.getReturnType().getName());
                op.setDescription("Introspected operation " + name3);
                Class<?>[] parms = m.getParameterTypes();
                for (int i = 0; i < parms.length; ++i) {
                    ParameterInfo pi = new ParameterInfo();
                    pi.setType(parms[i].getName());
                    pi.setName(("param" + i).intern());
                    pi.setDescription(("Introspected parameter param" + i).intern());
                    op.addParameter(pi);
                }
                mbean.addOperation(op);
            }
            if (log.isDebugEnabled()) {
                log.debug("Setting name: " + type2);
            }
            mbean.setName(type2);
            return mbean;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static String unCapitalize(String name2) {
        if (name2 == null || name2.length() == 0) {
            return name2;
        }
        char[] chars2 = name2.toCharArray();
        chars2[0] = Character.toLowerCase(chars2[0]);
        return new String(chars2);
    }

    static {
        specialMethods.put("preDeregister", "");
        specialMethods.put("postDeregister", "");
        supportedTypes = new Class[]{Boolean.class, Boolean.TYPE, Byte.class, Byte.TYPE, Character.class, Character.TYPE, Short.class, Short.TYPE, Integer.class, Integer.TYPE, Long.class, Long.TYPE, Float.class, Float.TYPE, Double.class, Double.TYPE, String.class, String[].class, BigDecimal.class, BigInteger.class, ObjectName.class, Object[].class, File.class};
    }
}

