/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.modeler;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.management.Attribute;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBeanNotificationBroadcaster;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.modeler.BaseAttributeFilter;
import org.apache.tomcat.util.modeler.BaseNotificationBroadcaster;
import org.apache.tomcat.util.modeler.ManagedBean;
import org.apache.tomcat.util.res.StringManager;

public class BaseModelMBean
implements DynamicMBean,
MBeanRegistration,
ModelMBeanNotificationBroadcaster {
    private static final Log log = LogFactory.getLog(BaseModelMBean.class);
    private static final StringManager sm = StringManager.getManager(BaseModelMBean.class);
    protected ObjectName oname = null;
    protected BaseNotificationBroadcaster attributeBroadcaster = null;
    protected BaseNotificationBroadcaster generalBroadcaster = null;
    protected ManagedBean managedBean = null;
    protected Object resource = null;
    static final Object[] NO_ARGS_PARAM = new Object[0];
    protected String resourceType = null;

    @Override
    public Object getAttribute(String name2) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (name2 == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(sm.getString("baseModelMBean.nullAttributeName")), sm.getString("baseModelMBean.nullAttributeName"));
        }
        if (this.resource instanceof DynamicMBean && !(this.resource instanceof BaseModelMBean)) {
            return ((DynamicMBean)this.resource).getAttribute(name2);
        }
        Method m = this.managedBean.getGetter(name2, this, this.resource);
        Object result = null;
        try {
            Class<?> declaring = m.getDeclaringClass();
            result = declaring.isAssignableFrom(this.getClass()) ? m.invoke((Object)this, NO_ARGS_PARAM) : m.invoke(this.resource, NO_ARGS_PARAM);
        }
        catch (InvocationTargetException e2) {
            Throwable t = e2.getTargetException();
            if (t == null) {
                t = e2;
            }
            if (t instanceof RuntimeException) {
                throw new RuntimeOperationsException((RuntimeException)t, sm.getString("baseModelMBean.invokeError", name2));
            }
            if (t instanceof Error) {
                throw new RuntimeErrorException((Error)t, sm.getString("baseModelMBean.invokeError", name2));
            }
            throw new MBeanException(e2, sm.getString("baseModelMBean.invokeError", name2));
        }
        catch (Exception e3) {
            throw new MBeanException(e3, sm.getString("baseModelMBean.invokeError", name2));
        }
        return result;
    }

    @Override
    public AttributeList getAttributes(String[] names) {
        if (names == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(sm.getString("baseModelMBean.nullAttributeNameList")), sm.getString("baseModelMBean.nullAttributeNameList"));
        }
        AttributeList response = new AttributeList();
        for (String name2 : names) {
            try {
                response.add(new Attribute(name2, this.getAttribute(name2)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return response;
    }

    public void setManagedBean(ManagedBean managedBean) {
        this.managedBean = managedBean;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.managedBean.getMBeanInfo();
    }

    @Override
    public Object invoke(String name2, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (this.resource instanceof DynamicMBean && !(this.resource instanceof BaseModelMBean)) {
            return ((DynamicMBean)this.resource).invoke(name2, params, signature);
        }
        if (name2 == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(sm.getString("baseModelMBean.nullMethodName")), sm.getString("baseModelMBean.nullMethodName"));
        }
        if (log.isDebugEnabled()) {
            log.debug("Invoke " + name2);
        }
        Method method = this.managedBean.getInvoke(name2, params, signature, this, this.resource);
        Object result = null;
        try {
            result = method.getDeclaringClass().isAssignableFrom(this.getClass()) ? method.invoke((Object)this, params) : method.invoke(this.resource, params);
        }
        catch (InvocationTargetException e2) {
            Throwable t = e2.getTargetException();
            log.error(sm.getString("baseModelMBean.invokeError", name2), t);
            if (t == null) {
                t = e2;
            }
            if (t instanceof RuntimeException) {
                throw new RuntimeOperationsException((RuntimeException)t, sm.getString("baseModelMBean.invokeError", name2));
            }
            if (t instanceof Error) {
                throw new RuntimeErrorException((Error)t, sm.getString("baseModelMBean.invokeError", name2));
            }
            throw new MBeanException((Exception)t, sm.getString("baseModelMBean.invokeError", name2));
        }
        catch (Exception e3) {
            log.error(sm.getString("baseModelMBean.invokeError", name2), e3);
            throw new MBeanException(e3, sm.getString("baseModelMBean.invokeError", name2));
        }
        return result;
    }

    static Class<?> getAttributeClass(String signature) throws ReflectionException {
        if (signature.equals(Boolean.TYPE.getName())) {
            return Boolean.TYPE;
        }
        if (signature.equals(Byte.TYPE.getName())) {
            return Byte.TYPE;
        }
        if (signature.equals(Character.TYPE.getName())) {
            return Character.TYPE;
        }
        if (signature.equals(Double.TYPE.getName())) {
            return Double.TYPE;
        }
        if (signature.equals(Float.TYPE.getName())) {
            return Float.TYPE;
        }
        if (signature.equals(Integer.TYPE.getName())) {
            return Integer.TYPE;
        }
        if (signature.equals(Long.TYPE.getName())) {
            return Long.TYPE;
        }
        if (signature.equals(Short.TYPE.getName())) {
            return Short.TYPE;
        }
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl != null) {
                return cl.loadClass(signature);
            }
        }
        catch (ClassNotFoundException cl) {
            // empty catch block
        }
        try {
            return Class.forName(signature);
        }
        catch (ClassNotFoundException e2) {
            throw new ReflectionException(e2, sm.getString("baseModelMBean.cnfeForSignature", signature));
        }
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (log.isDebugEnabled()) {
            log.debug("Setting attribute " + this + " " + attribute);
        }
        if (this.resource instanceof DynamicMBean && !(this.resource instanceof BaseModelMBean)) {
            try {
                ((DynamicMBean)this.resource).setAttribute(attribute);
            }
            catch (InvalidAttributeValueException e2) {
                throw new MBeanException(e2);
            }
            return;
        }
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(sm.getString("baseModelMBean.nullAttribute")), sm.getString("baseModelMBean.nullAttribute"));
        }
        String name2 = attribute.getName();
        Object value = attribute.getValue();
        if (name2 == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(sm.getString("baseModelMBean.nullAttributeName")), sm.getString("baseModelMBean.nullAttributeName"));
        }
        Object oldValue = null;
        Method m = this.managedBean.getSetter(name2, this, this.resource);
        try {
            if (m.getDeclaringClass().isAssignableFrom(this.getClass())) {
                m.invoke((Object)this, value);
            } else {
                m.invoke(this.resource, value);
            }
        }
        catch (InvocationTargetException e3) {
            Throwable t = e3.getTargetException();
            if (t == null) {
                t = e3;
            }
            if (t instanceof RuntimeException) {
                throw new RuntimeOperationsException((RuntimeException)t, sm.getString("baseModelMBean.invokeError", name2));
            }
            if (t instanceof Error) {
                throw new RuntimeErrorException((Error)t, sm.getString("baseModelMBean.invokeError", name2));
            }
            throw new MBeanException(e3, sm.getString("baseModelMBean.invokeError", name2));
        }
        catch (Exception e4) {
            log.error(sm.getString("baseModelMBean.invokeError", name2), e4);
            throw new MBeanException(e4, sm.getString("baseModelMBean.invokeError", name2));
        }
        try {
            this.sendAttributeChangeNotification(new Attribute(name2, oldValue), attribute);
        }
        catch (Exception ex) {
            log.error(sm.getString("baseModelMBean.notificationError", name2), ex);
        }
    }

    public String toString() {
        if (this.resource == null) {
            return "BaseModelMbean[" + this.resourceType + "]";
        }
        return this.resource.toString();
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        AttributeList response = new AttributeList();
        if (attributes == null) {
            return response;
        }
        String[] names = new String[attributes.size()];
        int n = 0;
        for (Object attribute : attributes) {
            Attribute item = (Attribute)attribute;
            names[n++] = item.getName();
            try {
                this.setAttribute(item);
            }
            catch (Exception exception) {}
        }
        return this.getAttributes(names);
    }

    public Object getManagedResource() throws InstanceNotFoundException, InvalidTargetObjectTypeException, MBeanException, RuntimeOperationsException {
        if (this.resource == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(sm.getString("baseModelMBean.nullResource")), sm.getString("baseModelMBean.nullResource"));
        }
        return this.resource;
    }

    public void setManagedResource(Object resource2, String type2) throws InstanceNotFoundException, MBeanException, RuntimeOperationsException {
        if (resource2 == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(sm.getString("baseModelMBean.nullResource")), sm.getString("baseModelMBean.nullResource"));
        }
        this.resource = resource2;
        this.resourceType = resource2.getClass().getName();
    }

    @Override
    public void addAttributeChangeNotificationListener(NotificationListener listener, String name2, Object handback) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException(sm.getString("baseModelMBean.nullListener"));
        }
        if (this.attributeBroadcaster == null) {
            this.attributeBroadcaster = new BaseNotificationBroadcaster();
        }
        if (log.isDebugEnabled()) {
            log.debug("addAttributeNotificationListener " + listener);
        }
        BaseAttributeFilter filter2 = new BaseAttributeFilter(name2);
        this.attributeBroadcaster.addNotificationListener(listener, filter2, handback);
    }

    @Override
    public void removeAttributeChangeNotificationListener(NotificationListener listener, String name2) throws ListenerNotFoundException {
        if (listener == null) {
            throw new IllegalArgumentException(sm.getString("baseModelMBean.nullListener"));
        }
        if (this.attributeBroadcaster != null) {
            this.attributeBroadcaster.removeNotificationListener(listener);
        }
    }

    @Override
    public void sendAttributeChangeNotification(AttributeChangeNotification notification) throws MBeanException, RuntimeOperationsException {
        if (notification == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(sm.getString("baseModelMBean.nullNotification")), sm.getString("baseModelMBean.nullNotification"));
        }
        if (this.attributeBroadcaster == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("AttributeChangeNotification " + notification);
        }
        this.attributeBroadcaster.sendNotification(notification);
    }

    @Override
    public void sendAttributeChangeNotification(Attribute oldValue, Attribute newValue) throws MBeanException, RuntimeOperationsException {
        String type2 = null;
        if (newValue.getValue() != null) {
            type2 = newValue.getValue().getClass().getName();
        } else if (oldValue.getValue() != null) {
            type2 = oldValue.getValue().getClass().getName();
        } else {
            return;
        }
        AttributeChangeNotification notification = new AttributeChangeNotification(this, 1L, System.currentTimeMillis(), "Attribute value has changed", oldValue.getName(), type2, oldValue.getValue(), newValue.getValue());
        this.sendAttributeChangeNotification(notification);
    }

    @Override
    public void sendNotification(Notification notification) throws MBeanException, RuntimeOperationsException {
        if (notification == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(sm.getString("baseModelMBean.nullNotification")), sm.getString("baseModelMBean.nullNotification"));
        }
        if (this.generalBroadcaster == null) {
            return;
        }
        this.generalBroadcaster.sendNotification(notification);
    }

    @Override
    public void sendNotification(String message) throws MBeanException, RuntimeOperationsException {
        if (message == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(sm.getString("baseModelMBean.nullMessage")), sm.getString("baseModelMBean.nullMessage"));
        }
        Notification notification = new Notification("jmx.modelmbean.generic", (Object)this, 1L, message);
        this.sendNotification(notification);
    }

    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter2, Object handback) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException(sm.getString("baseModelMBean.nullListener"));
        }
        if (log.isDebugEnabled()) {
            log.debug("addNotificationListener " + listener);
        }
        if (this.generalBroadcaster == null) {
            this.generalBroadcaster = new BaseNotificationBroadcaster();
        }
        this.generalBroadcaster.addNotificationListener(listener, filter2, handback);
        if (this.attributeBroadcaster == null) {
            this.attributeBroadcaster = new BaseNotificationBroadcaster();
        }
        if (log.isDebugEnabled()) {
            log.debug("addAttributeNotificationListener " + listener);
        }
        this.attributeBroadcaster.addNotificationListener(listener, filter2, handback);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo[] current = this.getMBeanInfo().getNotifications();
        MBeanNotificationInfo[] response = new MBeanNotificationInfo[current.length + 2];
        response[0] = new MBeanNotificationInfo(new String[]{"jmx.modelmbean.generic"}, "GENERIC", "Text message notification from the managed resource");
        response[1] = new MBeanNotificationInfo(new String[]{"jmx.attribute.change"}, "ATTRIBUTE_CHANGE", "Observed MBean attribute value has changed");
        System.arraycopy(current, 0, response, 2, current.length);
        return response;
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        if (listener == null) {
            throw new IllegalArgumentException(sm.getString("baseModelMBean.nullListener"));
        }
        if (this.generalBroadcaster != null) {
            this.generalBroadcaster.removeNotificationListener(listener);
        }
        if (this.attributeBroadcaster != null) {
            this.attributeBroadcaster.removeNotificationListener(listener);
        }
    }

    public String getModelerType() {
        return this.resourceType;
    }

    public String getClassName() {
        return this.getModelerType();
    }

    public ObjectName getJmxName() {
        return this.oname;
    }

    public String getObjectName() {
        if (this.oname != null) {
            return this.oname.toString();
        }
        return null;
    }

    @Override
    public ObjectName preRegister(MBeanServer server2, ObjectName name2) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("preRegister " + this.resource + " " + name2);
        }
        this.oname = name2;
        if (this.resource instanceof MBeanRegistration) {
            this.oname = ((MBeanRegistration)this.resource).preRegister(server2, name2);
        }
        return this.oname;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
        if (this.resource instanceof MBeanRegistration) {
            ((MBeanRegistration)this.resource).postRegister(registrationDone);
        }
    }

    @Override
    public void preDeregister() throws Exception {
        if (this.resource instanceof MBeanRegistration) {
            ((MBeanRegistration)this.resource).preDeregister();
        }
    }

    @Override
    public void postDeregister() {
        if (this.resource instanceof MBeanRegistration) {
            ((MBeanRegistration)this.resource).postDeregister();
        }
    }
}

