/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.MimeHeaderField;
import org.apache.tomcat.util.http.NamesEnumerator;
import org.apache.tomcat.util.http.ValuesEnumerator;
import org.apache.tomcat.util.res.StringManager;

public class MimeHeaders {
    public static final int DEFAULT_HEADER_SIZE = 8;
    private static final StringManager sm = StringManager.getManager("org.apache.tomcat.util.http");
    private MimeHeaderField[] headers = new MimeHeaderField[8];
    private int count;
    private int limit = -1;

    public void setLimit(int limit) {
        this.limit = limit;
        if (limit > 0 && this.headers.length > limit && this.count < limit) {
            MimeHeaderField[] tmp = new MimeHeaderField[limit];
            System.arraycopy(this.headers, 0, tmp, 0, this.count);
            this.headers = tmp;
        }
    }

    public void recycle() {
        this.clear();
    }

    public void clear() {
        for (int i = 0; i < this.count; ++i) {
            this.headers[i].recycle();
        }
        this.count = 0;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("=== MimeHeaders ===");
        Enumeration<String> e2 = this.names();
        while (e2.hasMoreElements()) {
            String n = e2.nextElement();
            Enumeration<String> ev = this.values(n);
            while (ev.hasMoreElements()) {
                pw.print(n);
                pw.print(" = ");
                pw.println(ev.nextElement());
            }
        }
        return sw.toString();
    }

    public void duplicate(MimeHeaders source2) throws IOException {
        for (int i = 0; i < source2.size(); ++i) {
            MimeHeaderField mhf = this.createHeader();
            mhf.getName().duplicate(source2.getName(i));
            mhf.getValue().duplicate(source2.getValue(i));
        }
    }

    public int size() {
        return this.count;
    }

    public MessageBytes getName(int n) {
        return n >= 0 && n < this.count ? this.headers[n].getName() : null;
    }

    public MessageBytes getValue(int n) {
        return n >= 0 && n < this.count ? this.headers[n].getValue() : null;
    }

    public int findHeader(String name2, int starting) {
        for (int i = starting; i < this.count; ++i) {
            if (!this.headers[i].getName().equalsIgnoreCase(name2)) continue;
            return i;
        }
        return -1;
    }

    public Enumeration<String> names() {
        return new NamesEnumerator(this);
    }

    public Enumeration<String> values(String name2) {
        return new ValuesEnumerator(this, name2);
    }

    private MimeHeaderField createHeader() {
        MimeHeaderField mh;
        if (this.limit > -1 && this.count >= this.limit) {
            throw new IllegalStateException(sm.getString("headers.maxCountFail", this.limit));
        }
        int len = this.headers.length;
        if (this.count >= len) {
            int newLength = this.count * 2;
            if (this.limit > 0 && newLength > this.limit) {
                newLength = this.limit;
            }
            MimeHeaderField[] tmp = new MimeHeaderField[newLength];
            System.arraycopy(this.headers, 0, tmp, 0, len);
            this.headers = tmp;
        }
        if ((mh = this.headers[this.count]) == null) {
            this.headers[this.count] = mh = new MimeHeaderField();
        }
        ++this.count;
        return mh;
    }

    public MessageBytes addValue(String name2) {
        MimeHeaderField mh = this.createHeader();
        mh.getName().setString(name2);
        return mh.getValue();
    }

    public MessageBytes addValue(byte[] b, int startN, int len) {
        MimeHeaderField mhf = this.createHeader();
        mhf.getName().setBytes(b, startN, len);
        return mhf.getValue();
    }

    public MessageBytes setValue(String name2) {
        for (int i = 0; i < this.count; ++i) {
            if (!this.headers[i].getName().equalsIgnoreCase(name2)) continue;
            for (int j = i + 1; j < this.count; ++j) {
                if (!this.headers[j].getName().equalsIgnoreCase(name2)) continue;
                this.removeHeader(j--);
            }
            return this.headers[i].getValue();
        }
        MimeHeaderField mh = this.createHeader();
        mh.getName().setString(name2);
        return mh.getValue();
    }

    public MessageBytes getValue(String name2) {
        for (int i = 0; i < this.count; ++i) {
            if (!this.headers[i].getName().equalsIgnoreCase(name2)) continue;
            return this.headers[i].getValue();
        }
        return null;
    }

    public MessageBytes getUniqueValue(String name2) {
        MessageBytes result = null;
        for (int i = 0; i < this.count; ++i) {
            if (!this.headers[i].getName().equalsIgnoreCase(name2)) continue;
            if (result == null) {
                result = this.headers[i].getValue();
                continue;
            }
            throw new IllegalArgumentException();
        }
        return result;
    }

    public String getHeader(String name2) {
        MessageBytes mh = this.getValue(name2);
        return mh != null ? mh.toString() : null;
    }

    public void removeHeader(String name2) {
        for (int i = 0; i < this.count; ++i) {
            if (!this.headers[i].getName().equalsIgnoreCase(name2)) continue;
            this.removeHeader(i--);
        }
    }

    public void removeHeader(int idx) {
        MimeHeaderField mh = this.headers[idx];
        mh.recycle();
        this.headers[idx] = this.headers[this.count - 1];
        this.headers[this.count - 1] = mh;
        --this.count;
    }
}

