/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.descriptor.web;

import java.io.IOException;
import java.net.URL;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.descriptor.DigesterFactory;
import org.apache.tomcat.util.descriptor.InputSourceUtil;
import org.apache.tomcat.util.descriptor.XmlErrorHandler;
import org.apache.tomcat.util.descriptor.web.Constants;
import org.apache.tomcat.util.descriptor.web.WebRuleSet;
import org.apache.tomcat.util.descriptor.web.WebXml;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.res.StringManager;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class WebXmlParser {
    private final Log log = LogFactory.getLog(WebXmlParser.class);
    private static final StringManager sm = StringManager.getManager(Constants.PACKAGE_NAME);
    private final Digester webDigester;
    private final WebRuleSet webRuleSet = new WebRuleSet(false);
    private final Digester webFragmentDigester;
    private final WebRuleSet webFragmentRuleSet;

    public WebXmlParser(boolean namespaceAware, boolean validation, boolean blockExternal) {
        this.webDigester = DigesterFactory.newDigester(validation, namespaceAware, this.webRuleSet, blockExternal);
        this.webDigester.getParser();
        this.webFragmentRuleSet = new WebRuleSet(true);
        this.webFragmentDigester = DigesterFactory.newDigester(validation, namespaceAware, this.webFragmentRuleSet, blockExternal);
        this.webFragmentDigester.getParser();
    }

    public boolean parseWebXml(URL url, WebXml dest, boolean fragment) throws IOException {
        if (url == null) {
            return true;
        }
        InputSource source2 = new InputSource(url.toExternalForm());
        source2.setByteStream(url.openStream());
        return this.parseWebXml(source2, dest, fragment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parseWebXml(InputSource source2, WebXml dest, boolean fragment) {
        WebRuleSet ruleSet;
        Digester digester;
        boolean ok = true;
        if (source2 == null) {
            return ok;
        }
        XmlErrorHandler handler = new XmlErrorHandler();
        if (fragment) {
            digester = this.webFragmentDigester;
            ruleSet = this.webFragmentRuleSet;
        } else {
            digester = this.webDigester;
            ruleSet = this.webRuleSet;
        }
        digester.push(dest);
        digester.setErrorHandler(handler);
        if (this.log.isDebugEnabled()) {
            this.log.debug(sm.getString("webXmlParser.applicationStart", source2.getSystemId()));
        }
        try {
            digester.parse(source2);
            if (handler.getWarnings().size() > 0 || handler.getErrors().size() > 0) {
                ok = false;
                handler.logFindings(this.log, source2.getSystemId());
            }
        }
        catch (SAXParseException e2) {
            this.log.error(sm.getString("webXmlParser.applicationParse", source2.getSystemId()), e2);
            this.log.error(sm.getString("webXmlParser.applicationPosition", "" + e2.getLineNumber(), "" + e2.getColumnNumber()));
            ok = false;
        }
        catch (Exception e3) {
            this.log.error(sm.getString("webXmlParser.applicationParse", source2.getSystemId()), e3);
            ok = false;
        }
        finally {
            InputSourceUtil.close(source2);
            digester.reset();
            ruleSet.recycle();
        }
        return ok;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.webDigester.setClassLoader(classLoader);
        this.webFragmentDigester.setClassLoader(classLoader);
    }
}

