/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.bcel.classfile;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import org.apache.tomcat.util.bcel.classfile.Constant;
import org.apache.tomcat.util.bcel.classfile.ConstantClass;
import org.apache.tomcat.util.bcel.classfile.ConstantPool;
import org.apache.tomcat.util.bcel.classfile.ConstantUtf8;

final class Utility {
    private Utility() {
    }

    static String compactClassName(String str2) {
        return str2.replace('/', '.');
    }

    static String getClassName(ConstantPool constant_pool, int index2) {
        Constant c = constant_pool.getConstant(index2, (byte)7);
        int i = ((ConstantClass)c).getNameIndex();
        c = constant_pool.getConstant(i, (byte)1);
        String name2 = ((ConstantUtf8)c).getBytes();
        return Utility.compactClassName(name2);
    }

    static void skipFully(DataInput file2, int length) throws IOException {
        int total = file2.skipBytes(length);
        if (total != length) {
            throw new EOFException();
        }
    }

    static void swallowFieldOrMethod(DataInput file2) throws IOException {
        Utility.skipFully(file2, 6);
        int attributes_count = file2.readUnsignedShort();
        for (int i = 0; i < attributes_count; ++i) {
            Utility.swallowAttribute(file2);
        }
    }

    static void swallowAttribute(DataInput file2) throws IOException {
        Utility.skipFully(file2, 2);
        int length = file2.readInt();
        Utility.skipFully(file2, length);
    }
}

