/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.bcel.classfile;

import java.io.DataInput;
import java.io.IOException;
import org.apache.tomcat.util.bcel.Const;
import org.apache.tomcat.util.bcel.classfile.ClassFormatException;
import org.apache.tomcat.util.bcel.classfile.Constant;

public class ConstantPool {
    private final Constant[] constant_pool;

    ConstantPool(DataInput input) throws IOException, ClassFormatException {
        int constant_pool_count = input.readUnsignedShort();
        this.constant_pool = new Constant[constant_pool_count];
        for (int i = 1; i < constant_pool_count; ++i) {
            byte tag;
            this.constant_pool[i] = Constant.readConstant(input);
            if (this.constant_pool[i] == null || (tag = this.constant_pool[i].getTag()) != 6 && tag != 5) continue;
            ++i;
        }
    }

    public Constant getConstant(int index2) {
        if (index2 >= this.constant_pool.length || index2 < 0) {
            throw new ClassFormatException("Invalid constant pool reference: " + index2 + ". Constant pool size is: " + this.constant_pool.length);
        }
        return this.constant_pool[index2];
    }

    public Constant getConstant(int index2, byte tag) throws ClassFormatException {
        Constant c = this.getConstant(index2);
        if (c == null) {
            throw new ClassFormatException("Constant pool at index " + index2 + " is null.");
        }
        if (c.getTag() != tag) {
            throw new ClassFormatException("Expected class `" + Const.getConstantName(tag) + "' at index " + index2 + " and got " + c);
        }
        return c;
    }
}

