/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.res.StringManager;

public final class IntrospectionUtils {
    private static final Log log = LogFactory.getLog(IntrospectionUtils.class);
    private static final StringManager sm = StringManager.getManager(IntrospectionUtils.class);
    private static final Hashtable<Class<?>, Method[]> objectMethods = new Hashtable();

    public static boolean setProperty(Object o, String name2, String value) {
        return IntrospectionUtils.setProperty(o, name2, value, true);
    }

    public static boolean setProperty(Object o, String name2, String value, boolean invokeSetProperty) {
        if (log.isDebugEnabled()) {
            log.debug("IntrospectionUtils: setProperty(" + o.getClass() + " " + name2 + "=" + value + ")");
        }
        String setter = "set" + IntrospectionUtils.capitalize(name2);
        try {
            Method[] methods2 = IntrospectionUtils.findMethods(o.getClass());
            Method setPropertyMethodVoid = null;
            Method setPropertyMethodBool = null;
            for (Method item : methods2) {
                Class<?>[] paramT = item.getParameterTypes();
                if (!setter.equals(item.getName()) || paramT.length != 1 || !"java.lang.String".equals(paramT[0].getName())) continue;
                item.invoke(o, value);
                return true;
            }
            for (Method method : methods2) {
                boolean ok = true;
                if (setter.equals(method.getName()) && method.getParameterTypes().length == 1) {
                    Class<?> paramType = method.getParameterTypes()[0];
                    Object[] params = new Object[1];
                    if ("java.lang.Integer".equals(paramType.getName()) || "int".equals(paramType.getName())) {
                        try {
                            params[0] = Integer.valueOf(value);
                        }
                        catch (NumberFormatException ex) {
                            ok = false;
                        }
                    } else if ("java.lang.Long".equals(paramType.getName()) || "long".equals(paramType.getName())) {
                        try {
                            params[0] = Long.valueOf(value);
                        }
                        catch (NumberFormatException ex) {
                            ok = false;
                        }
                    } else if ("java.lang.Boolean".equals(paramType.getName()) || "boolean".equals(paramType.getName())) {
                        params[0] = Boolean.valueOf(value);
                    } else if ("java.net.InetAddress".equals(paramType.getName())) {
                        try {
                            params[0] = InetAddress.getByName(value);
                        }
                        catch (UnknownHostException exc) {
                            if (log.isDebugEnabled()) {
                                log.debug("IntrospectionUtils: Unable to resolve host name:" + value);
                            }
                            ok = false;
                        }
                    } else if (log.isDebugEnabled()) {
                        log.debug("IntrospectionUtils: Unknown type " + paramType.getName());
                    }
                    if (ok) {
                        method.invoke(o, params);
                        return true;
                    }
                }
                if (!"setProperty".equals(method.getName())) continue;
                if (method.getReturnType() == Boolean.TYPE) {
                    setPropertyMethodBool = method;
                    continue;
                }
                setPropertyMethodVoid = method;
            }
            if (invokeSetProperty && (setPropertyMethodBool != null || setPropertyMethodVoid != null)) {
                Object[] params = new Object[]{name2, value};
                if (setPropertyMethodBool != null) {
                    try {
                        return (Boolean)setPropertyMethodBool.invoke(o, params);
                    }
                    catch (IllegalArgumentException biae) {
                        if (setPropertyMethodVoid != null) {
                            setPropertyMethodVoid.invoke(o, params);
                            return true;
                        }
                        throw biae;
                    }
                }
                setPropertyMethodVoid.invoke(o, params);
                return true;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e2) {
            log.warn(sm.getString("introspectionUtils.setPropertyError", name2, value, o.getClass()), e2);
        }
        catch (InvocationTargetException e3) {
            ExceptionUtils.handleThrowable(e3.getCause());
            log.warn(sm.getString("introspectionUtils.setPropertyError", name2, value, o.getClass()), e3);
        }
        return false;
    }

    public static Object getProperty(Object o, String name2) {
        String getter = "get" + IntrospectionUtils.capitalize(name2);
        String isGetter = "is" + IntrospectionUtils.capitalize(name2);
        try {
            Method[] methods2 = IntrospectionUtils.findMethods(o.getClass());
            Method getPropertyMethod = null;
            for (Method method : methods2) {
                Class<?>[] paramT = method.getParameterTypes();
                if (getter.equals(method.getName()) && paramT.length == 0) {
                    return method.invoke(o, (Object[])null);
                }
                if (isGetter.equals(method.getName()) && paramT.length == 0) {
                    return method.invoke(o, (Object[])null);
                }
                if (!"getProperty".equals(method.getName())) continue;
                getPropertyMethod = method;
            }
            if (getPropertyMethod != null) {
                Object[] params = new Object[]{name2};
                return getPropertyMethod.invoke(o, params);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e2) {
            log.warn(sm.getString("introspectionUtils.getPropertyError", name2, o.getClass()), e2);
        }
        catch (InvocationTargetException e3) {
            if (e3.getCause() instanceof NullPointerException) {
                return null;
            }
            ExceptionUtils.handleThrowable(e3.getCause());
            log.warn(sm.getString("introspectionUtils.getPropertyError", name2, o.getClass()), e3);
        }
        return null;
    }

    @Deprecated
    public static String replaceProperties(String value, Hashtable<Object, Object> staticProp, PropertySource[] dynamicProp) {
        return IntrospectionUtils.replaceProperties(value, staticProp, dynamicProp, null);
    }

    public static String replaceProperties(String value, Hashtable<Object, Object> staticProp, PropertySource[] dynamicProp, ClassLoader classLoader) {
        int pos;
        if (value.indexOf(36) < 0) {
            return value;
        }
        StringBuilder sb = new StringBuilder();
        int prev2 = 0;
        while ((pos = value.indexOf(36, prev2)) >= 0) {
            if (pos > 0) {
                sb.append(value.substring(prev2, pos));
            }
            if (pos == value.length() - 1) {
                sb.append('$');
                prev2 = pos + 1;
                continue;
            }
            if (value.charAt(pos + 1) != '{') {
                sb.append('$');
                prev2 = pos + 1;
                continue;
            }
            int endName = value.indexOf(125, pos);
            if (endName < 0) {
                sb.append(value.substring(pos));
                prev2 = value.length();
                continue;
            }
            String n = value.substring(pos + 2, endName);
            String v = IntrospectionUtils.getProperty(n, staticProp, dynamicProp, classLoader);
            if (v == null) {
                int col = n.indexOf(":-");
                if (col != -1) {
                    String dV = n.substring(col + 2);
                    v = IntrospectionUtils.getProperty(n = n.substring(0, col), staticProp, dynamicProp, classLoader);
                    if (v == null) {
                        v = dV;
                    }
                } else {
                    v = "${" + n + "}";
                }
            }
            sb.append(v);
            prev2 = endName + 1;
        }
        if (prev2 < value.length()) {
            sb.append(value.substring(prev2));
        }
        return sb.toString();
    }

    private static String getProperty(String name2, Hashtable<Object, Object> staticProp, PropertySource[] dynamicProp, ClassLoader classLoader) {
        String v = null;
        if (staticProp != null) {
            v = (String)staticProp.get(name2);
        }
        if (v == null && dynamicProp != null) {
            PropertySource propertySource;
            PropertySource[] propertySourceArray = dynamicProp;
            int n = propertySourceArray.length;
            for (int i = 0; i < n && (v = (propertySource = propertySourceArray[i]) instanceof SecurePropertySource ? ((SecurePropertySource)propertySource).getProperty(name2, classLoader) : propertySource.getProperty(name2)) == null; ++i) {
            }
        }
        return v;
    }

    public static String capitalize(String name2) {
        if (name2 == null || name2.length() == 0) {
            return name2;
        }
        char[] chars2 = name2.toCharArray();
        chars2[0] = Character.toUpperCase(chars2[0]);
        return new String(chars2);
    }

    public static void clear() {
        objectMethods.clear();
    }

    public static Method[] findMethods(Class<?> c) {
        Method[] methods2 = objectMethods.get(c);
        if (methods2 != null) {
            return methods2;
        }
        methods2 = c.getMethods();
        objectMethods.put(c, methods2);
        return methods2;
    }

    public static Method findMethod(Class<?> c, String name2, Class<?>[] params) {
        Method[] methods2;
        for (Method method : methods2 = IntrospectionUtils.findMethods(c)) {
            if (!method.getName().equals(name2)) continue;
            Class<?>[] methodParams = method.getParameterTypes();
            if (params == null && methodParams.length == 0) {
                return method;
            }
            if (params.length != methodParams.length) continue;
            boolean found = true;
            for (int j = 0; j < params.length; ++j) {
                if (params[j] == methodParams[j]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return method;
        }
        return null;
    }

    public static Object callMethod1(Object target, String methodN, Object param1, String typeParam1, ClassLoader cl) throws Exception {
        if (target == null || methodN == null || param1 == null) {
            throw new IllegalArgumentException(sm.getString("introspectionUtils.nullParameter"));
        }
        if (log.isDebugEnabled()) {
            log.debug("IntrospectionUtils: callMethod1 " + target.getClass().getName() + " " + param1.getClass().getName() + " " + typeParam1);
        }
        Class[] params = new Class[]{typeParam1 == null ? param1.getClass() : cl.loadClass(typeParam1)};
        Method m = IntrospectionUtils.findMethod(target.getClass(), methodN, params);
        if (m == null) {
            throw new NoSuchMethodException(target.getClass().getName() + " " + methodN);
        }
        try {
            return m.invoke(target, param1);
        }
        catch (InvocationTargetException ie) {
            ExceptionUtils.handleThrowable(ie.getCause());
            throw ie;
        }
    }

    public static Object callMethodN(Object target, String methodN, Object[] params, Class<?>[] typeParams) throws Exception {
        Method m = null;
        m = IntrospectionUtils.findMethod(target.getClass(), methodN, typeParams);
        if (m == null) {
            if (log.isDebugEnabled()) {
                log.debug("IntrospectionUtils: Can't find method " + methodN + " in " + target + " CLASS " + target.getClass());
            }
            return null;
        }
        try {
            Object o = m.invoke(target, params);
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append(target.getClass().getName()).append('.').append(methodN).append("( ");
                for (int i = 0; i < params.length; ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(params[i]);
                }
                sb.append(")");
                log.debug("IntrospectionUtils:" + sb.toString());
            }
            return o;
        }
        catch (InvocationTargetException ie) {
            ExceptionUtils.handleThrowable(ie.getCause());
            throw ie;
        }
    }

    public static Object convert(String object, Class<?> paramType) {
        Object result = null;
        if ("java.lang.String".equals(paramType.getName())) {
            result = object;
        } else if ("java.lang.Integer".equals(paramType.getName()) || "int".equals(paramType.getName())) {
            try {
                result = Integer.valueOf(object);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if ("java.lang.Boolean".equals(paramType.getName()) || "boolean".equals(paramType.getName())) {
            result = Boolean.valueOf(object);
        } else if ("java.net.InetAddress".equals(paramType.getName())) {
            try {
                result = InetAddress.getByName(object);
            }
            catch (UnknownHostException exc) {
                if (log.isDebugEnabled()) {
                    log.debug("IntrospectionUtils: Unable to resolve host name:" + object);
                }
            }
        } else if (log.isDebugEnabled()) {
            log.debug("IntrospectionUtils: Unknown type " + paramType.getName());
        }
        if (result == null) {
            throw new IllegalArgumentException(sm.getString("introspectionUtils.conversionError", object, paramType.getName()));
        }
        return result;
    }

    public static boolean isInstance(Class<?> clazz, String type2) {
        Class<?>[] ifaces;
        if (type2.equals(clazz.getName())) {
            return true;
        }
        for (Class<?> iface : ifaces = clazz.getInterfaces()) {
            if (!IntrospectionUtils.isInstance(iface, type2)) continue;
            return true;
        }
        Class<?> superClazz = clazz.getSuperclass();
        if (superClazz == null) {
            return false;
        }
        return IntrospectionUtils.isInstance(superClazz, type2);
    }

    public static interface SecurePropertySource
    extends PropertySource {
        public String getProperty(String var1, ClassLoader var2);
    }

    public static interface PropertySource {
        public String getProperty(String var1);
    }
}

