/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantLock;

public class SoftHashMap<K, V>
implements Map<K, V> {
    private static final int DEFAULT_RETENTION_SIZE = 100;
    private final Map<K, SoftValue<V, K>> map;
    private final int RETENTION_SIZE;
    private final Queue<V> strongReferences;
    private final ReentrantLock strongReferencesLock;
    private final ReferenceQueue<? super V> queue;

    public SoftHashMap() {
        this(100);
    }

    public SoftHashMap(int retentionSize) {
        this.RETENTION_SIZE = Math.max(0, retentionSize);
        this.queue = new ReferenceQueue();
        this.strongReferencesLock = new ReentrantLock();
        this.map = new ConcurrentHashMap<K, SoftValue<V, K>>();
        this.strongReferences = new ConcurrentLinkedQueue<V>();
    }

    public SoftHashMap(Map<K, V> source2) {
        this(100);
        this.putAll(source2);
    }

    public SoftHashMap(Map<K, V> source2, int retentionSize) {
        this(retentionSize);
        this.putAll(source2);
    }

    @Override
    public V get(Object key2) {
        this.processQueue();
        V result = null;
        SoftValue<V, K> value = this.map.get(key2);
        if (value != null) {
            result = (V)value.get();
            if (result == null) {
                this.map.remove(key2);
            } else {
                this.addToStrongReferences(result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToStrongReferences(V result) {
        this.strongReferencesLock.lock();
        try {
            this.strongReferences.add(result);
            this.trimStrongReferencesIfNecessary();
        }
        finally {
            this.strongReferencesLock.unlock();
        }
    }

    private void trimStrongReferencesIfNecessary() {
        while (this.strongReferences.size() > this.RETENTION_SIZE) {
            this.strongReferences.poll();
        }
    }

    private void processQueue() {
        SoftValue sv;
        while ((sv = (SoftValue)this.queue.poll()) != null) {
            this.map.remove(sv.key);
        }
    }

    @Override
    public boolean isEmpty() {
        this.processQueue();
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key2) {
        this.processQueue();
        return this.map.containsKey(key2);
    }

    @Override
    public boolean containsValue(Object value) {
        this.processQueue();
        Collection<V> values = this.values();
        return values != null && values.contains(value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        if (m == null || m.isEmpty()) {
            this.processQueue();
            return;
        }
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Set<K> keySet() {
        this.processQueue();
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        this.processQueue();
        Set<K> keys2 = this.map.keySet();
        if (keys2.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        ArrayList<V> values = new ArrayList<V>(keys2.size());
        for (Object key2 : keys2) {
            V v = this.get(key2);
            if (v == null) continue;
            values.add(v);
        }
        return values;
    }

    @Override
    public V put(K key2, V value) {
        this.processQueue();
        SoftValue sv = new SoftValue(value, key2, this.queue);
        SoftValue previous = this.map.put(key2, sv);
        this.addToStrongReferences(value);
        return previous != null ? (V)previous.get() : null;
    }

    @Override
    public V remove(Object key2) {
        this.processQueue();
        SoftValue<V, K> raw = this.map.remove(key2);
        return raw != null ? (V)raw.get() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.strongReferencesLock.lock();
        try {
            this.strongReferences.clear();
        }
        finally {
            this.strongReferencesLock.unlock();
        }
        this.processQueue();
        this.map.clear();
    }

    @Override
    public int size() {
        this.processQueue();
        return this.map.size();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.processQueue();
        Set<K> keys2 = this.map.keySet();
        if (keys2.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashMap kvPairs = new HashMap(keys2.size());
        for (Object key2 : keys2) {
            V v = this.get(key2);
            if (v == null) continue;
            kvPairs.put(key2, v);
        }
        return kvPairs.entrySet();
    }

    private static class SoftValue<V, K>
    extends SoftReference<V> {
        private final K key;

        private SoftValue(V value, K key2, ReferenceQueue<? super V> queue) {
            super(value, queue);
            this.key = key2;
        }
    }
}

